<div id="palleon-shapes" class="palleon-icon-panel-content panel-hide">
<?php Palleon::ad_manager('shapes'); ?>
    <div class="palleon-tabs">
        <ul class="palleon-tabs-menu">
            <li id="palleon-shapes-open" class="active" data-target="#palleon-all-shapes"><?php echo esc_html__('All', 'palleon'); ?></li>
            <li id="palleon-shape-setting-open" data-target="#palleon-shape-setting"><?php echo esc_html__('Shape', 'palleon'); ?></li>
        </ul>
        <div id="palleon-all-shapes" class="palleon-tab active">
            <div id="palleon-shapes-grid" class="palleon-grid palleon-shapes-grid four-column">
                <?php do_action('palleon_select_shape'); ?>
                <div class="palleon-shape" data-id="circle" title="<?php echo esc_attr__('Circle', 'palleon'); ?>">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="200" height="200" viewBox="0 0 200 200" xml:space="preserve">
                        <g transform="matrix(1.97 0 0 1.97 100 100)" id="1703336786828"  >
                        <circle style="stroke: rgb(0,0,0); stroke-width: 0; stroke-dasharray: none; stroke-linecap: butt; stroke-dashoffset: 0; stroke-linejoin: miter; stroke-miterlimit: 4; fill: rgb(255,255,255); fill-rule: nonzero; opacity: 1;" vector-effect="non-scaling-stroke"  cx="0" cy="0" r="50" />
                        </g>
                    </svg>
                </div>
                <div class="palleon-shape" data-id="ellipse" title="<?php echo esc_attr__('Ellipse', 'palleon'); ?>">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="200" height="200" viewBox="0 0 200 200" xml:space="preserve">
                        <g transform="matrix(1.28 0 0 1.28 100 100)" id="1703336889308"  >
                        <ellipse style="stroke: rgb(0,0,0); stroke-width: 0; stroke-dasharray: none; stroke-linecap: butt; stroke-dashoffset: 0; stroke-linejoin: miter; stroke-miterlimit: 4; fill: rgb(255,255,255); fill-rule: nonzero; opacity: 1;" vector-effect="non-scaling-stroke"  cx="0" cy="0" rx="75" ry="50" />
                        </g>
                    </svg>
                </div>
                <div class="palleon-shape" data-id="square" title="<?php echo esc_attr__('Square', 'palleon'); ?>">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="200" height="200" viewBox="0 0 200 200" xml:space="preserve">
                        <g transform="matrix(1.92 0 0 1.92 100 100)" id="1703336967063"  >
                        <rect style="stroke: rgb(0,0,0); stroke-width: 0; stroke-dasharray: none; stroke-linecap: butt; stroke-dashoffset: 0; stroke-linejoin: miter; stroke-miterlimit: 4; fill: rgb(255,255,255); fill-rule: nonzero; opacity: 1;" vector-effect="non-scaling-stroke"  x="-50" y="-50" rx="0" ry="0" width="100" height="100" />
                        </g>
                    </svg>
                </div>
                <div class="palleon-shape" data-id="rectangle" title="<?php echo esc_attr__('Rectangle', 'palleon'); ?>">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="200" height="200" viewBox="0 0 200 200" xml:space="preserve">
                        <g transform="matrix(0.96 0 0 0.96 100 100)" id="1703336994136"  >
                        <rect style="stroke: rgb(0,0,0); stroke-width: 0; stroke-dasharray: none; stroke-linecap: butt; stroke-dashoffset: 0; stroke-linejoin: miter; stroke-miterlimit: 4; fill: rgb(255,255,255); fill-rule: nonzero; opacity: 1;" vector-effect="non-scaling-stroke"  x="-100" y="-75" rx="0" ry="0" width="200" height="150" />
                        </g>
                    </svg>
                </div>
                <div class="palleon-shape" data-id="triangle" title="<?php echo esc_attr__('Triangle', 'palleon'); ?>">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="200" height="200" viewBox="0 0 200 200" xml:space="preserve">
                        <g transform="matrix(1.9 0 0 1.9 100 100)" id="1703337022890"  >
                        <polygon style="stroke: rgb(0,0,0); stroke-width: 0; stroke-dasharray: none; stroke-linecap: butt; stroke-dashoffset: 0; stroke-linejoin: miter; stroke-miterlimit: 4; fill: rgb(255,255,255); fill-rule: nonzero; opacity: 1;" vector-effect="non-scaling-stroke"  points="-50 50,0 -50,50 50" /></g>
                    </svg>
                </div>
                <div class="palleon-shape" data-id="trapezoid" title="<?php echo esc_attr__('Trapezoid', 'palleon'); ?>">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="200" height="200" viewBox="0 0 200 200" xml:space="preserve">
                        <g transform="matrix(0.64 0 0 0.64 100 100)" id="1703337057514"  >
                        <polygon style="stroke: rgb(0,0,0); stroke-width: 0; stroke-dasharray: none; stroke-linecap: butt; stroke-dashoffset: 0; stroke-linejoin: miter; stroke-miterlimit: 4; fill: rgb(255,255,255); fill-rule: nonzero; opacity: 1;" vector-effect="non-scaling-stroke"  points="-100,-50 100,-50 150,50 -150,50 " />
                        </g>
                    </svg>
                </div>
                <div class="palleon-shape" data-id="pentagon" title="<?php echo esc_attr__('Pentagon', 'palleon'); ?>">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="200" height="200" viewBox="0 0 200 200" xml:space="preserve">
                        <g transform="matrix(2.49 0 0 2.49 100 100)" id="1703337099944"  >
                        <polygon style="stroke: rgb(0,0,0); stroke-width: 0; stroke-dasharray: none; stroke-linecap: butt; stroke-dashoffset: 0; stroke-linejoin: miter; stroke-miterlimit: 4; fill: rgb(255,255,255); fill-rule: nonzero; opacity: 1;" vector-effect="non-scaling-stroke"  points="-24,36.9 -38.8,-8.7 0,-36.9 38.8,-8.7 24,36.9 " />
                        </g>
                    </svg>
                </div>
                <div class="palleon-shape" data-id="octagon" title="<?php echo esc_attr__('Octagon', 'palleon'); ?>">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="200" height="200" viewBox="0 0 200 200" xml:space="preserve">
                        <g transform="matrix(2.55 0 0 2.55 100 100)" id="1703337143397"  >
                        <polygon style="stroke: rgb(0,0,0); stroke-width: 0; stroke-dasharray: none; stroke-linecap: butt; stroke-dashoffset: 0; stroke-linejoin: miter; stroke-miterlimit: 4; fill: rgb(255,255,255); fill-rule: nonzero; opacity: 1;" vector-effect="non-scaling-stroke"  points="-15.5,37.4 -37.4,15.5 -37.4,-15.5 -15.5,-37.4 15.5,-37.4 37.4,-15.5 37.4,15.5 15.5,37.4 " />
                        </g>
                    </svg>
                </div>
                <div class="palleon-shape" data-id="emerald" title="<?php echo esc_attr__('Emerald', 'palleon'); ?>">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="200" height="200" viewBox="0 0 200 200" xml:space="preserve">
                        <g transform="matrix(0.77 0 0 0.77 100 100)" id="1703337170338"  >
                        <polygon style="stroke: rgb(0,0,0); stroke-width: 0; stroke-dasharray: none; stroke-linecap: butt; stroke-dashoffset: 0; stroke-linejoin: miter; stroke-miterlimit: 4; fill: rgb(255,255,255); fill-rule: nonzero; opacity: 1;" vector-effect="non-scaling-stroke"  points="0,-125 108,-62.5 108,62.5 0,125 -108,62.5 -108,-62.5 " />
                        </g>
                    </svg>
                </div>
                <div class="palleon-shape" data-id="star" title="<?php echo esc_attr__('Star', 'palleon'); ?>">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="200" height="200" viewBox="0 0 200 200" xml:space="preserve">
                        <g transform="matrix(0.81 0 0 0.81 100 100)" id="1703337202278"  >
                        <polygon style="stroke: rgb(0,0,0); stroke-width: 0; stroke-dasharray: none; stroke-linecap: butt; stroke-dashoffset: 0; stroke-linejoin: miter; stroke-miterlimit: 4; fill: rgb(255,255,255); fill-rule: nonzero; opacity: 1;" vector-effect="non-scaling-stroke"  points="-0.5,-113 29.5,-28 119.5,-28 49.5,27 72.5,113 -0.5,62 -73.5,113 -47.5,27 -119.5,-27 -29.5,-27 " />
                        </g>
                    </svg>
                </div>
                <div class="palleon-shape" data-id="diamond" title="<?php echo esc_attr__('Diamond', 'palleon'); ?>">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="200" height="200" viewBox="0 0 200 200" xml:space="preserve">
                        <g transform="matrix(1.01 0 0 1.01 100 100)" id="1703344442320"  >
                        <polygon style="stroke: rgb(0,0,0); stroke-width: 0; stroke-dasharray: none; stroke-linecap: butt; stroke-dashoffset: 0; stroke-linejoin: miter; stroke-miterlimit: 4; fill: rgb(255,255,255); fill-rule: nonzero; opacity: 1;" vector-effect="non-scaling-stroke"  points="-55.56,0 0,-96.23 55.56,0 0,96.23 " />
                        </g>
                    </svg>
                </div>
                <div class="palleon-shape" data-id="parallelogram" title="<?php echo esc_attr__('Parallelogram', 'palleon'); ?>">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="200" height="200" viewBox="0 0 200 200" xml:space="preserve">
                        <g transform="matrix(3.91 0 0 3.91 100 100)" id="1703343656588"  >
                        <polygon style="stroke: rgb(0,0,0); stroke-width: 0; stroke-dasharray: none; stroke-linecap: butt; stroke-dashoffset: 0; stroke-linejoin: miter; stroke-miterlimit: 4; fill: rgb(255,255,255); fill-rule: nonzero; opacity: 1;" vector-effect="non-scaling-stroke"  points="-15,-5 25,-5 15,5 -25,5 " />
                        </g>
                    </svg>
                </div>
                <?php
                for ($i = 1; $i <= 30; ++$i) {
                    echo '<div class="palleon-shape" data-id="customShape" title="' . esc_attr__('Custom Shape', 'palleon') . '">';
                    echo file_get_contents( PALLEON_PLUGIN_URL . 'assets/shapes/' . $i . '.svg' );
                    echo '</div>';
                }
                ?>
            </div>
            <button id="palleon-shape-loadmore" type="button" class="palleon-btn primary palleon-lg-btn btn-full"><?php echo esc_html__('Load more', 'palleon'); ?></button>
        </div>
        <div id="palleon-shape-setting" class="palleon-tab">
            <div id="palleon-shape-settings-info" class="notice notice-info">
                <h6><?php echo esc_html__( 'No shape is selected', 'palleon' ); ?></h6>
                <?php echo esc_html__('Select a shape to adjust the settings.', 'palleon'); ?>
            </div>
            <div id="palleon-shape-settings">
                <div class="palleon-control-wrap">
                    <label class="palleon-control-label"><?php echo esc_html__('Fill Style', 'palleon'); ?></label>
                    <div class="palleon-control">
                        <select id="palleon-shape-gradient" class="palleon-select" autocomplete="off">
                            <option value="none" selected><?php echo esc_html__('Solid Color', 'palleon'); ?></option>
                            <option value="vertical"><?php echo esc_html__('Vertical Gradient', 'palleon'); ?></option>
                            <option value="horizontal"><?php echo esc_html__('Horizontal Gradient', 'palleon'); ?></option>
                            <option value="diagonal"><?php echo esc_html__('Diagonal Gradient', 'palleon'); ?></option>
                        </select>
                    </div>
                </div>
                <div id="shape-gradient-settings">
                    <div class="palleon-control-wrap control-text-color">
                        <label class="palleon-control-label"><?php echo esc_html__('Color 1', 'palleon'); ?></label>
                        <div class="palleon-control">
                            <input id="shape-gradient-color-1" type="text" class="palleon-colorpicker disallow-empty" autocomplete="off" value="#9C27B0" />
                        </div>
                    </div>
                    <div class="palleon-control-wrap control-text-color">
                        <label class="palleon-control-label"><?php echo esc_html__('Color 2', 'palleon'); ?></label>
                        <div class="palleon-control">
                            <input id="shape-gradient-color-2" type="text" class="palleon-colorpicker disallow-empty" autocomplete="off" value="#000000" />
                        </div>
                    </div>
                    <div class="palleon-control-wrap control-text-color">
                        <label class="palleon-control-label"><?php echo esc_html__('Color 3', 'palleon'); ?></label>
                        <div class="palleon-control">
                            <input id="shape-gradient-color-3" type="text" class="palleon-colorpicker allow-empty" autocomplete="off" value="" />
                        </div>
                    </div>
                    <div class="palleon-control-wrap control-text-color">
                        <label class="palleon-control-label"><?php echo esc_html__('Color 4', 'palleon'); ?></label>
                        <div class="palleon-control">
                            <input id="shape-gradient-color-4" type="text" class="palleon-colorpicker allow-empty" autocomplete="off" value="" />
                        </div>
                    </div>
                </div>
                <div id="shape-fill-color" class="palleon-control-wrap">
                    <label class="palleon-control-label"><?php echo esc_html__('Fill Color', 'palleon'); ?></label>
                    <div class="palleon-control">
                        <input id="palleon-shape-color" type="text" class="palleon-colorpicker allow-empty" autocomplete="off" value="#fff" />
                    </div>
                </div>
                <div class="palleon-control-wrap">
                    <label class="palleon-control-label"><?php echo esc_html__('Outline Size', 'palleon'); ?></label>
                    <div class="palleon-control">
                        <input id="shape-outline-width" class="palleon-form-field" type="number" value="0" data-min="0" data-max="1000" step="1" autocomplete="off">
                    </div>
                </div>
                <div class="palleon-control-wrap">
                    <label class="palleon-control-label"><?php echo esc_html__('Outline Color', 'palleon'); ?></label>
                    <div class="palleon-control">
                        <input id="shape-outline-color" type="text" class="palleon-colorpicker disallow-empty" autocomplete="off" value="#000000" />
                    </div>
                </div>
                <div id="palleon-shape-rounded-corners">
                    <div class="palleon-control-wrap label-block">
                        <label class="palleon-control-label slider-label"><?php echo esc_html__('Rounded Corners', 'palleon'); ?><span>0</span></label>
                        <div class="palleon-control">
                            <input id="shape-rounded-corners" type="range" min="0" max="100" value="0" step="1" class="palleon-slider" autocomplete="off">
                        </div>
                    </div>
                </div>
                <div class="palleon-control-wrap conditional">
                    <label class="palleon-control-label"><?php echo esc_html__('Shadow', 'palleon'); ?></label>
                    <div class="palleon-control palleon-toggle-control">
                        <label class="palleon-toggle">
                            <input id="palleon-shape-shadow" class="palleon-toggle-checkbox" data-conditional="#shape-shadow-settings" type="checkbox" autocomplete="off" />
                            <div class="palleon-toggle-switch"></div>
                        </label>
                    </div>
                </div>
                <div id="shape-shadow-settings" class="d-none conditional-settings">
                    <div class="palleon-control-wrap">
                        <label class="palleon-control-label"><?php echo esc_html__('Shadow Color', 'palleon'); ?></label>
                        <div class="palleon-control">
                            <input id="shape-shadow-color" type="text" class="palleon-colorpicker disallow-empty" autocomplete="off" value="#000" />
                        </div>
                    </div>
                    <div class="palleon-control-wrap">
                        <label class="palleon-control-label"><?php echo esc_html__('Shadow Blur', 'palleon'); ?></label>
                        <div class="palleon-control">
                            <input id="shape-shadow-blur" class="palleon-form-field" type="number" value="5" step="1" autocomplete="off">
                        </div>
                    </div>
                    <div class="palleon-control-wrap">
                        <label class="palleon-control-label"><?php echo esc_html__('Offset X', 'palleon'); ?></label>
                        <div class="palleon-control">
                            <input id="shape-shadow-offset-x" class="palleon-form-field" type="number" value="5" step="1" autocomplete="off">
                        </div>
                    </div>
                    <div class="palleon-control-wrap">
                        <label class="palleon-control-label"><?php echo esc_html__('Offset Y', 'palleon'); ?></label>
                        <div class="palleon-control">
                            <input id="shape-shadow-offset-y" class="palleon-form-field" type="number" value="5" step="1" autocomplete="off">
                        </div>
                    </div>
                </div>
                <hr/>
                <div class="palleon-control-wrap label-block">
                    <div class="palleon-control">
                        <div class="palleon-btn-group icon-group">
                            <button type="button" class="palleon-horizontal-center palleon-btn tooltip tooltip-top" data-title="<?php echo esc_attr__('Horizontal Align Center', 'palleon'); ?>"><span class="material-icons">align_horizontal_center</span></button>
                            <button type="button" class="palleon-vertical-center palleon-btn tooltip tooltip-top" data-title="<?php echo esc_attr__('Vertical Align Center', 'palleon'); ?>"><span class="material-icons">vertical_align_center</span></button>
                        </div>
                    </div>
                </div>
                <div class="palleon-control-wrap label-block">
                    <label class="palleon-control-label slider-label"><?php echo esc_html__('Opacity', 'palleon'); ?><span>1</span></label>
                    <div class="palleon-control">
                        <input id="shape-opacity" type="range" min="0" max="1" value="1" step="0.1" class="palleon-slider" autocomplete="off">
                    </div>
                </div>
                <div class="palleon-control-wrap label-block">
                    <label class="palleon-control-label slider-label"><?php echo esc_html__('Skew X', 'palleon'); ?><span>0</span></label>
                    <div class="palleon-control">
                        <input id="shape-skew-x" type="range" min="0" max="180" value="0" step="1" class="palleon-slider" autocomplete="off">
                    </div>
                </div>
                <div class="palleon-control-wrap label-block">
                    <label class="palleon-control-label slider-label"><?php echo esc_html__('Skew Y', 'palleon'); ?><span>0</span></label>
                    <div class="palleon-control">
                        <input id="shape-skew-y" type="range" min="0" max="180" value="0" step="1" class="palleon-slider" autocomplete="off">
                    </div>
                </div>
                <div class="palleon-control-wrap label-block">
                    <label class="palleon-control-label slider-label"><?php echo esc_html__('Rotate', 'palleon'); ?><span>0</span></label>
                    <div class="palleon-control">
                        <input id="shape-rotate" type="range" min="0" max="360" value="0" step="1" class="palleon-slider" autocomplete="off">
                    </div>
                </div>
                <div id="shape-custom-width-wrap">
                    <div class="palleon-control-wrap">
                        <label class="palleon-control-label"><?php echo esc_html__('Custom Width', 'palleon'); ?></label>
                        <div class="palleon-control">
                            <input id="shape-custom-width" class="palleon-form-field" type="number" value="" data-min="0" data-max="10000" step="1" autocomplete="off">
                        </div>
                    </div>
                    <div class="palleon-control-wrap">
                        <label class="palleon-control-label"><?php echo esc_html__('Custom Height', 'palleon'); ?></label>
                        <div class="palleon-control">
                            <input id="shape-custom-height" class="palleon-form-field" type="number" value="" data-min="0" data-max="10000" step="1" autocomplete="off">
                        </div>
                    </div>
                    <div class="palleon-control-wrap label-block">
                        <label class="palleon-control-label"><?php echo esc_html__('Aspect Ratio', 'palleon'); ?></label>
                        <div class="palleon-control">
                            <div class="palleon-aspect-ratio">
                                <input id="palleon-shape-ratio-w" class="palleon-form-field" type="number" value="12" autocomplete="off">
                                <span class="material-icons">clear</span>
                                <input id="palleon-shape-ratio-h" class="palleon-form-field" type="number" value="16" autocomplete="off">
                                <button id="palleon-shape-ratio-lock" type="button" class="palleon-btn palleon-lock-unlock"><span class="material-icons">lock_open</span></button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>