# Admin and Site Enhancements (ASE)

Contributors: qriouslad  
Donate link: https://bowo.io/asenha-sp-rdm  
Tags: enhancements, tweaks, optimizations, tools  
Requires at least: 4.6  
Tested up to: 6.4.3  
Stable tag: 6.9.6  
Requires PHP: 5.6  
License: GPLv2 or later  
License URI: http://www.gnu.org/licenses/gpl-2.0.html

![](.wordpress-org/banner-772x250.png)

Duplicate post, post order, image resize, email via SMTP, admin menu editor, custom css / code, disable gutenberg and much more in a single plugin.

## Description

Admin and Site Enhancements (ASE) helps you to **easily enhance** various admin workflows and site aspects while **replacing multiple plugins** doing it.

**Pro version** with Lifetime Deal (LTD) is available at [www.wpase.com](https://www.wpase.com/rdme-to-web).

Here's a detailed walkthrough of ASE at v6.2.5 by Ferdy Korpershoek.

https://www.youtube.com/watch?v=noesMRHohVM

Here's a demo of ASE Pro at v6.2.6 by David McCan.

https://www.youtube.com/watch?v=0va_LsaeBfY

[**See more video reviews >>**](https://www.wpase.com/video-reviews/)

### What Users Say

_"ASE easily **replaces a dozen or more plugins** I install on **every website project**. Super lightweight and easy to use."_ ~[NetzzJD](https://wordpress.org/support/topic/amazing-must-have-plugin-2/)

_"I bought the lifetime deal and was **blown away by the quality**, and the free version replaces SO many other plugins too. LOVE THIS!"_ ~[Jacob Wonder](https://wordpress.org/support/topic/amazing-plugin-2545/)

_"ASE is an amazing plugin! **Time and money saver**. Thank you!"_ ~[Iulian Baciu](https://wordpress.org/support/topic/amazing-plugin-precious/)

[**See more reviews >>**](https://www.wpase.com/)

### FEATURES & MODULES

**60 modules** in total:
**52** free modules (16 has Pro features) | **8** Pro modules

[**See all features >>**](https://www.wpase.com/features/)

### Content Management

* **[[Pro](https://www.wpase.com/rdme-to-web)] Custom Content Types**. Conveniently register and edit custom post types, custom taxonomies, custom field groups and options pages that integrates with Bricks, Breakdance, Oxygen and Elementor.
* **Content Duplication**. One-click duplication of pages, posts and CPTs. [ASE Pro](https://www.wpase.com/rdme-to-web) enables duplication only for certain user roles and adds location option for duplication link.
* **Content Order**. Enable custom ordering of various post types that are hierarchical or support page attributes, in wp-admin and on the frontend. [ASE Pro](https://www.wpase.com/rdme-to-web) enables ordering of post types that are non-hierarchical and does not support page attributes, and also enable toggling taxonomy terms and / or excerpt on the ordering page.
* **[[Pro](https://www.wpase.com/rdme-to-web)] Terms Order**. Enable custom ordering of terms from various taxonomies in wp-admin and on the frontend.
* **[[Pro](https://www.wpase.com/rdme-to-web)] Media Categories**. Add categories for the media library and enable drag-and-drop categorization of media items.
* **Media Replacement**. Easily replace any type of media file with a new one while ensuring no existing links will break. [ASE Pro](https://www.wpase.com/rdme-to-web) allows replacing media from the grid view of media library as well.
* **Media Library Infinite Scrolling**. Re-enable infinite scrolling in the grid view of the media library. 
* **SVG Upload**. Allow some or all user roles to upload SVG files, which will then be sanitized to keep things secure.
* **[[Pro](https://www.wpase.com/rdme-to-web)] AVIF Upload**. Enable uploading AVIF files in the Media Library.
* **External Permalinks**. Enable pages, posts and/or custom post types to have permalinks that point to external URLs.
* **Open All External Links in New Tab**. Force all links to external sites to open in new browser tab via target="\_blank" attribute.
* **Allow Custom Navigation Menu Items to Open in New Tab**. Allow custom navigation menu items to have links that open in new browser tab via target="\_blank" attribute.
* **Auto-Publish Posts with Missed Schedule**. Trigger publishing of scheduled posts of all types marked with "missed schedule", anytime the site is visited.

### Admin Interface

* **Clean Up Admin Bar**. Remove various default elements from the admin bar. [ASE Pro](https://www.wpase.com/rdme-to-web) enables removal of admin bar items from other plugins.
* **Hide Admin Notices**. Clean up admin pages by moving notices into a separate panel easily accessible via the admin bar. [ASE Pro](https://www.wpase.com/rdme-to-web) adds the option to also hide notices for non-admins.
* **Disable Dashboard Widgets**. Clean up and speed up the dashboard by completely disabling some or all widgets.
* **Hide Admin Bar**. Hide admin bar on the frontend for all or some user roles. [ASE Pro](https://www.wpase.com/rdme-to-web) also allows hiding the admin bar on the backend for all or some user roles.
* **Wider Admin Menu**. Give the admin menu more room to better accommodate wider items.
* **Admin Menu Editor / Organizer**. Customize the order of the admin menu and optionally change menu item title or hide some items. [ASE Pro](https://www.wpase.com/rdme-to-web) enables always hiding menu items for some or all user roles and reorder submenu items.
* **[[Pro](https://www.wpase.com/rdme-to-web)] Admin Columns Manager**. Manage and organize columns in the admin listing for pages, posts and custom post types. Currently supports ASE, ACF and Meta Box custom fields.
* **Enhance List Tables**. Improve the usefulness of listing pages of various post types by adding / removing columns and elements, e.g. featured image, excerpt, ID columns.
* **Display Active Plugins First**: Display active / activated plugins at the top of the Installed Plugins list.
* **Custom Admin Footer Text**: Customize the text you see on the footer of wp-admin pages. [ASE Pro](https://www.wpase.com/rdme-to-web) enables media upload / insertion.

### Log In / Log Out

* **Change Login URL**. Make the login URL more memorable and secure by customizing it. [ASE Pro](https://www.wpase.com/rdme-to-web) adds compatibility with login process during WooCommerce checkout and custom 404 redirect on default login URLs.
* **Login ID Type**. Restrict login ID to username or email address only.
* **Site Identity on Login Page**. Use the site icon and URL to replace the default WordPress logo with link to wordpress.org on the login page.
* **Log In/Out Menu**. Enable log in, log out and dynamic log in/out menu item for addition to any menu.
* **Last Login Column**. Log when users on the site last logged in and display the date and time in the users list table.
* **Redirect After Login / Logout**. Set custom redirect URL for all or some user roles after login / logout.

### Custom Code

* **[[Pro](https://www.wpase.com/rdme-to-web)] Code Snippets Manager**. Conveniently add and manage CSS / SCSS, JS, HTML and PHP code snippets to modify your site's content, design, behaviour and functionalities
* **Custom Admin CSS**.
* **Custom Frontend CSS**.
* **Insert &lt;head&gt;, &lt;body&gt; and &lt;footer&gt; Code**. Easily insert &lt;meta&gt;, &lt;link&gt;, &lt;script&gt; and &lt;style&gt; tags for tracking, analytics, etc.
* **Custom Body Class**.
* **Manage ads.txt and app-ads.txt**.
* **Manage robots.txt**.

### Disable Components

* **Disable Gutenberg**. Disable the Gutenberg block editor for some or all applicable post types. Optionally disable frontend block assets. [ASE Pro](https://www.wpase.com/rdme-to-web) adds an option to disable only on / except on certain post types.
* **Disable Comments**. Disable comments for some or all public post types. [ASE Pro](https://www.wpase.com/rdme-to-web) adds an option to disable only on / except on certain post types.
* **Disable REST API**. Disable REST API access for non-authenticated users and remove URL traces from &lt;head&gt;, HTTP headers and WP RSD endpoint.
* **Disable Feeds**. Disable all RSS, Atom and RDF feeds.
* **Disable All Updates**. Completely disable core, theme and plugin updates and auto-updates. Will also disable update checks, notices and emails.
* **Disable Smaller Components**. Prevent smaller components from running or loading. e.g. generator &lt;meta&gt; tag, version number, Windows Live Writer (WLW) manifest &lt;link&gt; tag, Really Simple Discovery (RSD) &lt;link&gt; tag, WordPress shortlink &lt;link&gt; tag in &lt;head&gt;, and also dashicons CSS and JS files, emoji support, jQuery Migrate and block-based widgets settings screen.

### Security

* **Limit Login Attempts**. Prevent brute force attacks by limiting the number of failed login attempts allowed per IP address. [ASE Pro](https://www.wpase.com/rdme-to-web) adds IP whitelisting, which is also useful to unblock users.
* **Obfuscate Author Slugs**. Obfuscate publicly exposed author page URLs that shows the user slugs / usernames.
* **Email Address Obfuscator**. Obfuscate email address to prevent spam bots from harvesting them,. [ASE Pro](https://www.wpase.com/rdme-to-web) enables output of obfuscated mailto: link and also auto-obfuscation of email addresses in post content.
* **Disable XML-RPC**. Protect your site from brute force, DOS and DDOS attacks via XML-RPC. Also disables trackbacks and pingbacks.

### Optimizations

* **Image Upload Control**. Resize newly uploaded, large images to a smaller dimension and delete originally uploaded files. BMPs and non-transparent PNGs will be converted to JPGs and resized. [ASE Pro](https://www.wpase.com/rdme-to-web) enables conversion to WebP with custom conversion quality.
* **Revisions Control**. Prevent bloating the database by limiting the number of revisions to keep for some or all post types supporting revisions.
* **Heartbeat Control**. Modify the interval of the WordPress heartbeat API or disable it on admin pages, post creation/edit screens and/or the frontend.

### Utilities

* **Email Delivery**. Set custom sender name and email. Optionally use external SMTP service to ensure notification and transactional emails from your site are being delivered to inboxes.
* **[[Pro](https://www.wpase.com/rdme-to-web)] Local User Avatar**. Enable usage of any image from WordPress Media Library as user avatars.
* **Multiple User Roles**. Enable assignment of multiple roles during user account creation and editing.
* **Image Sizes Panel**. Display a panel showing and linking to all available sizes when viewing an image in the media library. [ASE Pro](https://www.wpase.com/rdme-to-web) adds a convenient button to copy the image URL on click.
* **View Admin as Role**. View admin pages and the site (logged-in) as one of the non-administrator user roles.
* **Password Protection**. Password-protect the entire site to hide the content from public view and search engine bots / crawlers. [ASE Pro](https://www.wpase.com/rdme-to-web) adds IP whitelisting and bypassing via URL parameter.
* **Maintenance Mode**. Show a simple maintenance message. [ASE Pro](https://www.wpase.com/rdme-to-web) adds option to set custom page / browser tab title and use WYSIWYG editor, image / solid color background and custom CSS.
* **Redirect 404 to Homepage**. Perform 301 (permanent) redirect to the homepage for all 404 (not found) pages.
* **Display System Summary**. Show web server software, PHP version, database software and server IP address in the "At a Glance" dashboard widget.
* **Search Engines Visibility Status**. Show admin bar status and admin notice when search engines are set to be discouraged from indexing the site.

[**See all features >>**](https://www.wpase.com/features/)

### ASE Pro

**Lifetime Deal (LTD)** is available at [www.wpase.com](https://www.wpase.com/rdme-to-web).

## Screenshots

1. Content Management
   ![Content Management](.wordpress-org/screenshot-1.png)
2. Admin Interface
   ![Admin Interface](.wordpress-org/screenshot-2.png)
3. Log In | Log Out
   ![Log In | Log Out](.wordpress-org/screenshot-3.png)
4. Custom Code
   ![Custom Code](.wordpress-org/screenshot-4.png)
5. Disable Components
   ![Disable Components](.wordpress-org/screenshot-5.png)
6. Security
   ![Security](.wordpress-org/screenshot-6.png)
7. Optimizations
   ![Optimizations](.wordpress-org/screenshot-7.png)
8. Utilities
   ![Utilities](.wordpress-org/screenshot-8.png)
9. Admin Menu Organizer module
   ![Admin Menu Organizer module](.wordpress-org/screenshot-9.png)
10. Email Delivery module
   ![Email Delivery module](.wordpress-org/screenshot-10.png)

## Frequently Asked Questions

### How Do I Reset ASE Settings / Configuration?

If for whatever reason you need to remove ASE and reset the settings / configuration, please follow these steps:

1. Access your website via FTP and delete ASE plugin folder at /wp-content/plugins/admin-site-enhancements/
2. Login to your site via the default URL, /wp-admin/ or /wp-login.php
3. Install [SQL Buddy](https://wordpress.org/plugins/sql-buddy/) plugin, open it, and click on the wp_options table
4. Use the small filter icon at the top of wp_options table rows, and filter for “option_name” => “contains” => “admin_site_enhancements”. You should get 3 options . Click on each one and hit the “Delete” icon in the bottom-right corner.
5. Re-install and re-configure ASE as needed.

You can skip step 1 and 2 if you still have access to your wp-admin dashboard.

## Changelog

**Admin and Site Enhancements (ASE) v1.0.0** was released on October 17, 2022. Since then, there have been **69 _point_ releases** (e.g. 1.1.0 ) and **86 _patch_ releases** (e.g. 4.9.1). 

Each **_point release_** usually corresponds with the addition of one new module/feature. Each module/feature usually is the equivalent of one (or more) single-purpose plugin. Each **_patch release_** usually contain one or more bugfix or improvements to existing modules/features.

[**Upgrade to ASE Pro**](https://www.wpase.com/chnlg-to-web) now. Lifetime Deal (LTD) available.

### 6.9.6.2 (2024.04.01) - ASE Pro

* **[FIXED in Pro] Content Management >> Content Order**: fixed PHP warnings as reported by Yoshihiro T. and a developer at mez#####e.co.

### 6.9.6.1 (2024.04.01) - ASE Pro

* **[FIXED in Pro] Content Management >> Custom Content Types >> Options Pages**: fixed an issue where getting an option page's option value in the frontend returns empty value. Props to Darren for reporting this with a short but clear screencast that illustrates the issue in Breakdance builder.

### 6.9.6 (2024.04.01) - ASE Free and Pro

* **[IMPROVED in Free and Pro] Log In | Log Out >> Redirect After Login & Logout**: make it possible to redirect to the homepage by leaving the redirection slug input blank. Props to [@mateuszkalamarz](https://wordpress.org/support/users/mateuszkalamarz/) for [reporting the issue](https://wordpress.org/support/topic/redirect-after-login-doesnt-allow-front-page/) and prompting the improvement.

* **[IMPROVED in Free and Pro] Log In | Log Out >> Change Login URL**: properly redirect /wp-login (without .php) to the /not_found/ URL. It was showing the login form on some scenarios. Props to Artur M. for reporting this and help with troubleshooting.

* **[IMPROVED in Pro] Content Management >> Content Order**: it's now possible to enable custom ordering for post types that are not hierarchical and don't support page attributes, e.g. posts and WooCommerce products. Props to Kay L., Eirini Z. and Hampus E. for suggesting this improvement.

* **[IMPROVED in Pro] Admin Interface >> Admin Columns Manager**: Post Parent and Menu Order are now included in Default columns for all post types.

* **[FIXED in Free and Pro] Disable Components >> Disable Gutenberg**: fixed an issue where the "Add Form" button from Gravity Forms is not present next to "Add Media" button in the post/page edit screen when gutenberg / block editor is disabled for a post type. Props to [Kazam Creative](https://wordpress.org/support/users/goldenagemedia/) for [reporting the issue](https://wordpress.org/support/topic/bug-add-shortcode-to-visual-editor-buttons-disappear/).

* **[FIXED in Pro] Content Management >> Custom Content Types**: in some scenarios, the WYSIWYG field is not responsive, and thus, not usable when editing a post using that field type with the block editor. This is now fixed. Props to Philipp Z. for reporting the issue and facilitating the troubleshooting.

* **[FIXED in Free and Pro] ASE Settings**: fixed PHP warning reported by [@osblaga](https://wordpress.org/support/users/osblaga/) in [this thread](https://wordpress.org/support/topic/error-when-activating-wp-ase-plugin/).

### 6.9.5 (2024.03.25) - ASE Free and Pro

* **[IMPROVED in Free and Pro] Admin Interface >> Enhance List Tables**: added the option to show file size column in the media library list view. Props to [@tinnyfusion](https://wordpress.org/support/users/tinnyfusion/) for [suggesting this](https://wordpress.org/support/topic/add-file-size-column-to-media-library/) and providing the code snippet to base this upon.

* **[IMPROVED in Free and Pro] Security >> Limit Login Attempts**: change input type for the limit numbers from text to number.

* **[IMPROVED in Free and Pro] Improve security**: properly escape unescaped $variables on ASE settings page and in various modules.

* **[IMPROVED in Pro] Custom Code >> Code Snippets Manager**: when disabling safe mode via the admin bar icon/toggle fails, a message is now shown that links to the [documentation](https://www.wpase.com/documentation/code-snippets-manager/) on how to disable it manually via wp-config.php. Props to Nelson T. for prompting the improvement.

* **[IMPROVED in Pro] Content Management >> Custom Content Types >> Custom Field Groups**: you can now choose default value(s) for radio, select and checkbox fields. Props to Max F. for pointing out this missing option.

* **[IMPROVED in Pro] Disable Components >> Disable Gutenberg & Disable Comments**: added additional option to "Disable only on" or "Disable except on" the selected post types. This should make it easier to include or exclude only certain post types despite new post types being registered on the site. i.e. no need to continually check newly added post types to disable Gutenberg / comments on.

* **[IMPROVED in Pro] Content Management >> Media Categories**: css adjustment to fix toolbar items spilling over to the second line in the grid view on certain scenarios.

* **[IMPROVED in Free and Pro] Increase code modularity** across all modules. One is by switching from autoloading vendor libraries using Composer to loading them when the corresponding modules are enabled. The other by breaking down module category classes, e.g. class-content-management.php, that has grown large as new features and modules are added to each category, into smaller ones, e.g. class-content-duplication.php.

* **[CHANGED in Free and Pro] Disable Components >> Disable Block-based Widgets Settings Screen**: is now moved under Disable Smaller Components module.

* **[CHANGED in Pro] Content Management >> Terms Order**: custom terms ordering was previously limited to users with 'manage_options' capability, e.g. administrator, and now is available for users with 'manage_categories' capability, e.g. administrator, editor, shop_manager. Props to Marco R. for the feedback.

* **[FIXED in Free and Pro] Security >> Limit Login Attempts**: Fixed an issue where sorting by date-time (Last Attempt On) in the failed login attempts log table did not work as expected. Going forward, the log table will by default be sorted by Last Attempt On in descending order. Props to a user whose name escapes memory at the moment!

* **[FIXED in Free and Pro] ASE Settings**: fixed an issue where TinyMCE Visual editor is not responsive / working in Firefox browser. e.g. in Custom Admin Footer Text and Maintenance Mode modules. Props to Michael S. for reporting the issue. Replaced Text tab/editor with a code button to perform raw HTML editing.

* **[FIXED in Pro] Custom Code >> Code Snippets Manager**: fixed an issue where TinyMCE Visual editor for snippet description is not responsive / working in Firefox browser. Props to Michael S. for hinting at the issue. Replaced Text tab/editor with a code button to perform raw HTML editing.

* **[FIXED in Free and Pro] Admin Interface >> Admin Menu Organizer**: fixed a PHP warning that occurs in certain scenarios.

* **[FIXED in Pro] Utilities >> Maintenance Mode**: fixed an issue where background image is not properly loaded certain scenarios.

### 6.9.4 (2024.03.18) - ASE Free and Pro

* **[IMPROVED in Pro] Content Management >> Media Categories**: when in grid view, parent categories are now properly assigned when uploading new media files to a sub-category view, i.e. after clicking on a sub-category in the categories tree. Props to Alin T. for suggesting the improvement. Also simplified the UI by removing the "Media Categories" title above the categories tree.

* **[IMPROVED in Pro] Content Management >> Custom Content Types >> Custom Field Groups**: "This is a required field" validation now works properly for File, Radio and Checkbox fields, while removing it from the True False field, as an empty checkbox is a valid value as well. Props to Michael S. for testing and reporting this.

* **[IMPROVED in Pro] Utilities >> Maintenance Mode**: add an option to set the title of the maintenance page, which is visible in browser tab title. Props to Gálik J. for the suggestion. Also enabled wpautop() for the output of heading and description. i.e. line breaks now appear on the maintenance page.

* **[IMPROVED in Free and Pro] Disable Components >> Disable Smaller Components >> Disable Emoji Support**: will also now disable conversion of text emojis into picture emojis, a.k.a. smilies. Props to [@ofmarconi](https://wordpress.org/support/users/ofmarconi/) for [reporting the issue](https://wordpress.org/support/topic/even-with-the-option-to-disable-emoji-it-continues-to-be-changed-on-the-front-en/) on their Elementor site.

* **[IMPROVED in Pro] Admin Interface >> Custom Admin Footer Text**: added "Add Media" and "Visual | Text" switcher.

* **[FIXED in Free and Pro] ASE Settings**: fixed an issue in some scenarios, of not being able to enter any value in the TinyMCE Visual editor. Props to Nelson T. who first reported the issue in the Custom Admin Footer Text module and being patient and supportive throughout the troubleshooting process. Additional props to Gustavo F. for reporting the same issue in the Maintenance Mode module and facilitating the troubleshooting process as well.

* **[FIXED in Pro] Custom Code >> Code Snippets Manager**: fixed an issue in some scenarios, of not being able to enter any value in the snippet description's TinyMCE Visual editor. Props to Michael S. for reporting the issue.

* **[FIXED in Free and Pro] Log In | Log Out >> Change Login URL**: fixed an issue where on some circumstances, after a successful login, redirection to the default / custom 404 page instead of the admin dashboard occurs. Props to Ignazio D.M. for reporting the issue.

* **[FIXED in Pro] Content Management >> Custom Content Types >> Custom Field Groups**: fixed an issue with Elementor integration where Loop Grid widget is not showing the correct set of CPT content. Props to Thomas B. for reporting the issue in great detail (problematic URLs and annotated screenshots) and facilitating the troubleshooting process.

* **[FIXED in Pro] Content Management >> Custom Content Types >> Custom Field Groups**: fixed a couple of deprecation notices when in PHP v8.2 for creating dynamic property.

* **[FIXED in Pro] Content Management >> Custom Content Types >> Custom Field Groups**: fixed an issue where custom field group's extra settings were not properly being saved.

* **[FIXED in Free and Pro] Admin Interface >> Hide Admin Notices**: fixed missing settings panels in Loco Translate, e.g. Add New Language panel, as they are using divs with .notice class, which were hidden inside the Notices panel in the admin bar. These panels are now excluded from being hidden. Props to [@inboundbe](https://wordpress.org/support/users/inboundbe/) and [@kirollosa](https://wordpress.org/support/users/kirollosa/) for [reporting the issue](https://wordpress.org/support/topic/issue-with-loco-translate-2/).

* **[FIXED in Free and Pro] Content Mangement >> Media Replacement**: fixed an issue where on certain scenarios, when editing a page / post / CPT with the block editor, there were media frame layout issues when trying to change the featured image. Props to Philipp Z. for reporting the issue and facilitating troubleshooting, which includes recording a 43 seconds screencast of the issue.

* **[FIXED in Free and Pro] Optimizations >> Revisions Control**: fixed an issue when entering 0 revisions as the limit, after saving changes, it will revert back to the default 10 revisions. Props to [@pressthemes1](https://wordpress.org/support/users/pressthemes1/) for [reporting the issue](https://wordpress.org/support/topic/all-setting-revisions-control-to-0/).

### 6.9.3 (2024.03.12) - ASE Free and Pro

* **[IMPROVED in Pro] Utilities >> Maintenance Mode**: enable WYSIWYG editor for heading and description, which allows for links, some custom HTML and custom styling if you need it. Also added ability to add custom CSS along with addition of a page overlay div element, which you can style to overlay the background image, e.g. make it darker or brighter to increase contrast with the maintenance message.

* **[IMPROVED in Pro] Content Management >> Content Duplication**: added duplication link in the publishing section of post edit screen, both in the classic editor and block editor. Also added an option to choose on which locations to show the duplication link: list view post action row / admin bar / edit screen publish section.

* **[FIXED in Free and Pro] ASE Settings**: prevent JS error when iThemes Security Pro / Solid Security Pro plugin is active.

* **[FIXED in Pro] Content Management >> Custom Content Types >> Custom Field Groups**: fixed an issue where returning the value of a custom field inside a GenerateBlocks Query Loop returns an empty value after update to v6.9.1. Props to Arne O. for reporting the issue in details and patiently facilitating the troubleshooting process. This also fixed a similar issue with showing custom field values in Breakdance Post Loop Builder. Props to Philipp Z. for reporting it.

* **[CHANGED in Pro] Content Management >> AVIF Upload**: remove link to avif.io, which is no longer online. This module will likely be removed once WP v6.5 is released and is widely adopted, as built-in AVIF support will be [included in WP core](https://make.wordpress.org/core/2024/02/23/wordpress-6-5-adds-avif-support/).

### 6.9.2 (2024.03.07) - ASE Free and Pro

* **[CHANGED in Pro] Content Management >> Custom Content Types**: custom field groups and options pages creation is now enabled by default when Custom Content Types module is enabled. Also updated module description and settings to reflect this.

* **[FIXED in Free and Pro] Optimizations >> Image Upload Control**: added checks to prevent PHP fatal error and warnings when uploading non-image files and WebP conversion is enabled. Props to Peter J. and Gilang R. for reporting the fatal error issue.

* **[FIXED in Free and Pro] Security >> Limit Login Attemtps**: fixed an issue where under certain conditions, the login page would endlessly reload making it impossible to login. Props to [eangulus](https://wordpress.org/support/users/eangulus/), [andreawriessnegger](https://wordpress.org/support/users/andreawriessnegger/), [eangulus](https://wordpress.org/support/users/eangulus/), Max F. and Eric for reporting this patiently and in great detail in the wp.org [support forum](https://wordpress.org/support/topic/something-not-right-with-limit-login-attempts/) and via email.

### 6.9.1 (2024.03.07) - ASE Free and Pro

* **[IMPROVED in Pro] Content Management >> Custom Content Types**: added the ability to create Options Pages, which for example, you can use to allow clients to easily edit parts of the website, e.g. office address, organization mission statement, etc. This has also been integrated with Oxygen, Bricks, Breakdance and Elementor, i.e. you can see fields from options pages showing up as dynamic data source.

* **[IMPROVED in Pro] Optimizations >> Image Upload Control**: in previous version, BMP, PNG and JPG images will be converted first to WebP before being resized  to the specified. Now, uploads will be resized first before conversion to WebP. This will result in even smaller file size while maintaining image quality. Props to Adryan for the astute observation and detailed reporting of the issue.

* **[IMPROVED in Pro] Content Management >> Custom Content Types >> Custom Field Groups**: the WYSIWYG field now has a 'code' button to show the HTML version of content being added / copy-pasted. Useful for cleaning up from unwanted code, e.g. CSS classes, weird formatting, etc. Props to Michael S. for suggesting something similar.

* **[IMPROVED in Pro] Custom Code >> Code Snippets Manager**: snippet description editor now has the Visual-Text tabs. Useful for cleaning up description from unwanted code, e.g. CSS classes, weird formatting, etc, when the description is copy-pasted from elsewhere. Props to Michael S. for suggesting this.

* **[IMPROVED in Free and Pro] Log In | Log Out >> Change Login URL**: will now correctly output an error message on failed login: "Error: Invalid username/email or incorrect password.". This is a custom message that does not give away valuable info to potential hackers. e.g. does not indicate that the username is correct but password is wrong. Props to Sven K. for reporting the issue.

* **[FIXED in Pro] Custom Code >> Code Snippets Manager**: fixed missing "Snippet Categories" sub-menu item after the last release. Props to Herbert S. for reporting the issue.

* **[FIXED in Free] Utilities >> Maintenance Mode**: properly hide the 'Image' and 'Color' background options in the free version. Props to Michael I. for reporting the issue.

* **[FIXED in Pro] Content Management >> Custom Content Type**: custom taxonomy key / slug was limited to 20 characters despite the UI / description saying it's limited to 32 characters, per the hard limit set by [register_taxonomy()(https://developer.wordpress.org/reference/functions/register_taxonomy/). Props to Michael S. for reporting the issue.

### 6.9.0.1 (2024.02.26) - ASE Pro

* **[FIXED in Pro] Content Management >> Content Duplication**: fixed a bug that can cause PHP warning or fatal error. Props to Benjamin P., Elon R., and Yoshihiro T. for reporting the issue immediately after the release of v6.9.0.

### 6.9.0 (2024.02.26) - ASE Free and Pro

* **[NEW in Free and Pro] Admin Interface >> Custom Admin Footer Text**: Customize the text you see on the footer of wp-admin pages.

* **[IMPROVED in Pro] Content Management >> Custom Content Types >> Custom Field Groups**: added 4 **new field types: number, radio, checkbox and (image) gallery**. All of them works with the repeater field and have been integrated with Bricks, Breakdance, Oxygen and Elementor, and also fully supported in the Admin Columns Manager module.

* **[IMPROVED in Pro] Content Management >> Custom Content Types >> Custom Field Groups**: added option to choose preview size for file (image) field type. You can choose between thumbnail (cropped/square) or medium (uncropped). Some users prefer the cropped version as it's smaller file size, while some other users prefer the uncropped version which for example, shows brand logos nicely.

* **[IMPROVED in Pro] Admin Interface >> Admin Columns Manager**: list table is now responsive, i.e. looks and works nicely on mobile. Props to Pablo R. for reporting the issue when vieweing on mobile.

* **[IMPROVED in Pro] Log In | Log Out >> Change Login URL**: added option to choose which URL to redirect to when visitors try to access default WP login URLs/slugs (/wp-admin/, /admin/, /wp-login.php, /login/). Props to Igor P. for the suggestion.

* **[IMPROVED in Pro] Content Management >> Content Duplication**: added option to choose which user role(s) the duplication feature is available for. Props to Igor P. for the suggestion.

* **[IMPROVED in Pro] Content Management >> Custom Content Types >> Custom Post Types**: small usability tweak. Add a close icon in the icon picker of the custom post type creation / edit screen. Props to Steven Y. for the suggestion.

### 6.8.3.1 (2024.02.20) - ASE Pro

* **[FIXED in Pro] Admin Interface >> Admin Columns Manager**: fixed an issue where column widths are not properly applied.

### 6.8.3 (2024.02.20) - ASE Free and Pro

* **[NEW in Pro] Content Management >> Custom Content Types**: added **integration of ASE custom fields as Elementor builder's dynamic data provider** All field types, except for repeater fields, can be displayed using the Text Editor widget. It's also possible to use compatible field types as data sources for URLs, files/media, colors, numbers, image and video.

* **[IMPROVED in Free and Pro] Admin Interface >> Hide Admin Notices**: mouse cursor now changes to a pointer (hand icon pointing upwards) when hovering on the 'Notices' menu in the admin bar. Props to @cvladan for [suggesting this](https://github.com/qriouslad/admin-site-enhancements/issues/10).

* **[FIXED in Pro] Custom Code >> Code Snippets Manager**: fixed PHP warning on login page. Props to Sunny L., Linda L. and Francois G. for reporting the issue along with the full error entry that helped with troubleshooting.

* **[FIXED in Free and Pro] ASE Settings Page**: fixed incompatibility with US Weather Widget plugin (a plugin that's last updated 6 years ago) causing the settings page to load partially and become non-functional. Props to James B for reporting the issue.

### 6.8.2 (2024.02.16) - ASE Free and Pro

* **[IMPROVEMENT in Free and Pro] Content Management >> Content Duplication**: added an option to choose where to redirect after performing duplication of a post. Choices are the edit screen of the new/duplicate post, or the list view for the post type, e.v. View all posts. Props to [@americancreativeconsulting](https://wordpress.org/support/users/americancreativeconsulting/) for [suggesting](https://wordpress.org/support/topic/feature-request-duplicate-page-without-opening-to-it/) this improvement.

* **[FIXED in Free and Pro] Content Management >> Media Replacement**: fixed an issue where media replace is not working in non-English wp-admin. Also fixed an issue where the "Drop files to upload" blue overlay is not closing after drag-and-dropping a file in the media replacement modal window. Props to Andi P. for reporting these issues in details and with screencasts and also facilitating troubleshooting further.

* **[FIXED in Free and Pro] Log In | Log Out >> Last Login Column**: fixed PHP warning when logging out of temporary account created with [Temporary Login Without Password](https://wordpress.org/plugins/temporary-login-without-password/) plugin. Props to Alex S. for reporting the issue.

* **[FIXED in Pro] Terms Order**: fixed PHP notice and warning on certain scenarios. Props to Brian N. for reporting the issue with a copy of the error log entry, which helped with troubleshooting.

* **[FIXED in Pro] Custom Code >> Code Snippets Manager**: fixed an issue where users are not able to logout in certain scenarios when Code Snippets Manager is active. Props to HMDIA for reporting the issue and assisting with troubleshooting.

### 6.8.0 (2024.02.13) - ASE Free and Pro

* **[NEW in Free and Pro] Log In Log Out >> Login ID Type**: Restrict login ID to username or email address only.

* **[IMPROVED in Free and Pro] Custom Code >> Custom Admin CSS**: change the hook in use to print custom CSS on page from 'admin_enqueue_scripts' to 'admin_print_footer_scripts'. This increases the chance that the custom CSS will override previously declared CSS.

* **[IMPROVED in Free and Pro] Utilities >> Display System Summary**: added server IP address. Props to Koen A. for the suggestion.

* **[IMPROVED in Free and Pro] Security >> Limit Login Attempts**: improve detection of user's IP address, especially for cases where the user is behind a proxy server. Prevents locking out all users from that proxy server when one is being locked out. Props to Gunnar A. for detecting and reporting the issue and suggesting a solution to help fix that.

* **[FIXED in Pro] Admin Interface >> Admin Columns Manager**: fixed an issue where columns of certain post type listings are showing empty cells / values. This was originally reported in detail with GeoDirectory's Packages listing by Martin K., which also helped with the troubleshooting.

* **[FIXED in Free and Pro] ASE settings page**: fixed plugin conflict between ASE and WordPress Mentions Légales plugin causing ASE settings page to be blank and dysfunctional. Props to Gilbert G. for reporting and helping with troubleshooting.

* **[FIXED in Pro] Admin Interface >> Admin Columns Manager**: fixed PHP fatal error when there's a product that does not have an SKU and the Products column is shown in WooCommerce Orders page. Props to Jacob E. for reporting the issue and helping with troubleshooting.

* **[FIXED in Free and Pro] Content Management >> Content Duplication**: fixed PHP warnings as reported by [@webvizionph](https://wordpress.org/support/users/webvizionph/) in details [here](https://wordpress.org/support/topic/warning-attempt-to-read-property-post_type-on-null-in-home/).

* **[FIXED in Pro] Content Management >> Media Replacement**: fixed an issue where the "Select New Media File" button does not work in the grid view of the media library when viewing a media item and trying to perform media replacement. Props to Stefan P. for reporting the issue.

* **[FIXED in Pro] Content Management >> Media Replacement**: fixed an issue where the new image (for replacement) is not being shown in the frontend view of the site and in the block editor's Featured Image section. Props to David H. for their investigative work detailing the issues and the scenarios under which they appear, and also for helping with the troubleshooting process.

### 6.7.0 (2024.02.07) - ASE Free and Pro

* **[NEW in Free and Pro] Admin Interface >> Display Active Plugins First**: new module to display active / activated plugins at the top of the Installed Plugins list. Useful when your site has many deactivated plugins for testing or development purposes.

* **[IMPROVED in Pro] Content Management >> Custom Content Types**: added **integration of ASE custom fields as Breakdance builder's dynamic data provider** with full support for the repeater field. All field types can be output using a simple text element in Breakdance, and it's also possible to output compatible field types as URLs and be used in the image and video elements for further customization. Relationship field support in Post Loop Builder requires intervention from Breakdance team, and ASE has initiated the process towards that end.

* **[IMPROVED in Pro] Admin Interface >> Admin Columns Manager**: added a column containing list of products being ordered for WooCommerce Orders listing page. Props to Jacob E. for the suggestion.

* **[FIXED in Free and Pro] Admin Interface >> Hide Admin Notices**: will now only be active in wp-admin pages and not on the frontend. Changed the hook used to load inline CSS styles that was causing the PHP warning issue of "headers already sent" when viewing the Customizer, as reported by [@socialsparkmedia](https://wordpress.org/support/users/socialsparkmedia/) and [@elonreynolds](https://wordpress.org/support/users/elonreynolds/) [here](https://wordpress.org/support/topic/php-warning-using-divi-theme-with-ase-pro-6-5-0/) and [here](https://wordpress.org/support/topic/warning-message-when-opening-customizer/). Additionally, when Breakdance builder is actively managing a post/page, a similar error was also reported and has also been fixed. Props to Val J. for reporting this issue in detail and facilitating troubleshooting.

* **[FIXED in Free and Pro] Content Management >> Media Replacement**: fixed a bug that occurs when an image of a different (mime) type than the image to replace is being used for the replacement. A check has been added that will output a warning when that happens, and will disable the Perform Replacement button until an image of the same type is selected. Props to David H. and Andi P. for reporting issues related to this bug, and help with providing detailed information to help with troubleshooting.

* **[FIXED in Free and Pro] Utilities >> Display System Summary**: fixed PHP warning when there's an error getting database information via mysqli_connect(). Props to Val J. for reporting the issue and helping with troubleshooting.

### 6.6.0 (2024.01.30) - ASE Free and Pro

* **[NEW][Free][Pro] Utilities >> Search Engines Visibility Status**: new module to show admin bar status and admin notice when search engines are set to be discouraged from indexing the site, which is set through a "Search engine visibility" checkbox in Settings >> Reading. Props to David S. for suggesting the feature and providing the code snippet (generated with ChatGPT Plus) that this module was based on.

* **[FIXED][Free][Pro] Security >> Limit Login Attempts**: fixed an issue where lockout is not effecive after reaching the limit of failed login attempts and being shown the lockout screen. Reloading the lockout screen would simply show the login form again, even when lockout period is not over yet. This happens only when using default login URL at /wp-login.php. Props to [@dywoo02](https://wordpress.org/support/users/dywoo02/) for [reporting this](https://wordpress.org/support/topic/limit-login-attempts-limit-login-attempts-and-correct-access-data/) and doing a thorough investigative work. That gave a clue and help for looking at the right places in the code to fix the issue.

* **[FIXED][Free][Pro] Log In | Log Out >> Change Login URL**: undo a change in v6.5.1 that was returning the custom login URL for wp_login_url(). This caused common login URLs like /admin, /wp-admin and /login to redirect to the custom login URL, thus making it pointless to have a custom login URL. With this reversion, those common long URLs will redirect to /not_found/ 404 error page. Props to Hayato for reporting this issue after updating to v6.5.1.

* **[FIXED][Pro] Local User Avatar**: fixed PHP warning when opening the block editor and in other scenarios. Props to Rio M. and Brian W. for reporting the issue.

### 6.5.1 (2024.01.29) - ASE Free and Pro

* **[IMPROVED][Pro] Content Management >> Custom Content Types**: added **integration of ASE custom fields as Oxygen and Bricks builder's dynamic data provider**. The repeater and relationship fields are fully supported in Bricks builder's Query Loop. Repeater field suport in Oxygen builder's Repeater module requires implementation from within Oxygen builder's plugin, so, if you'd like to see that happen, please comment / vote / request it at [this Github issue](https://github.com/soflyy/oxygen-bugs-and-features/issues/3499), which is their official feature request channel.

* **[IMPROVED][Free][Pro] Admin Interface >> Clean Up Admin Bar**: when 'Howdy' is hidden and "Avatar Display" is disabled in Settings >> Discussion, the profile menu will also hide the default user avatar and the profile dropdown will no longer show empty space where the avatar was shown before. Props to Stijn V. for reporting the issue and providing the one-line code fix for it.

* **[IMPROVED][Free][Pro] Log In | Log Out >> Change Login URL**: after resetting password, the "Log in" link in "Your password has been reset. Log in" will now link to the custom login URL. More generally, wp_login_url() will now return the custom login URL. Props to [@timbre-design](https://wordpress.org/support/topic/change-login-url-disables-reset-password-function/) for reporting the issue.

* **[FIXED][Free][Pro] Log In | Log Out >> Change Login URL**: when a user is logged-in and attempt to visit the custom login URL, the user was being logged out and redirected to the login page. Now, the user be redirected to /wp-admin/ and will stay logged-in. Props to [@boah123](https://wordpress.org/support/users/boah123/) for [reporting the issue](https://wordpress.org/support/topic/change-login-url-disables-remember-me/) with detailed steps to reproduce it.

* **[FIXED][Pro] Utilities >> Local User Avatar**: fixed fatal error in certain scenario when $user object is not being returned.

* **[FIXED][Pro] Admin Interface >> Admin Menu Organizer**: fixed an issue where /wp-admin/ (Dashboard) is not accessible upon successful login when this module is active. Props to John M. for reporting the issue and help with narrowing down the probably cause.

* **[FIXED][Pro] Admin Interface >> Admin Columns Manager**: fixed an issue with SureMembers Access Groups listing page not showing the group title and action links when Admin Columns Manager is active. Props to Volker D. for reporting the issue and facilitating troubleshooting.

* **[FIXED][Pro] Admin Interface >> Admin Columns Manager**: nothing is listed in the Custom Fields section when organizing columns for WooCommerce Orders (shop_order), including custom fields from ACF. Props to Jacob E. for reporting the issue and providing additional information to help troubleshoot the issue.

### 6.5.0 (2024.01.22) - ASE Free and Pro

* **[NEW][Free][Pro] Content Management >> Media Library Infinite Scrolling**: Re-enable infinite scrolling in the grid view of the media library. Useful for scrolling through a large library. Props to [@benbaudart](https://wordpress.org/support/users/benbaudart/) for [suggesting this](https://wordpress.org/support/topic/feature-request-infinite-scroll-in-media-library/).

* **[IMPROVED][Pro] Admin Interface >> Admin Columns Manager**: make WP core, ASE, ACF and Meta Box columns with values that are sortable to be automatically sortable, i.e. can be sorted ASC / DESC on clicking the column header. **To enable this, please open the admin columns manager for the post types you have, and click Save Changes**. Props to Julian S. and Uli L for suggesting a feature in this area.

* **[IMPROVED][Free][Pro] Admin Interface >> Hide Admin Notices**: will now properly handle hiding notices on GenerateBlocks settings page. Props to [@tpfoster](https://wordpress.org/support/users/tpfoster/) for [reporting this](https://wordpress.org/support/topic/hide-admin-notices-doesnt-work-on-every-page/) in great detail, which helped with troubleshooting.

* **[IMPROVED][Pro] Utilities >> Local User Avatar**: make sure local avatar is used for [get_avatar_url()](https://developer.wordpress.org/reference/functions/get_avatar_url/). Props to Sunny T. for reporting that Cwicly Image block does not load local avatar when "Dynamic Data >> WordPress >> Author Profile Picture" is selected as the data source, @ardyan for reporting gravatar image was still loaded on their site.

* **[FIXED][Pro] Admin Interface >> Admin Columns Manager**: fixed an issue where Screen Options toggle was not properly toggling RankMath's SEO Title and SEO Desc columns. Props to Sunny T. for reporting the issue.

* **[FIXED][Pro] Admin Interface >> Admin Columns Manager**: fixed missing column values from EDD Orders page. Props to Deborah S. for reporting the issue and helping with troubleshooting.

* **[FIXED][Free][Pro] Optimizations >> Heartbeat Control**: fixed PHP warnign. Props to Maek M. for reporting the issue along with the error log entry.

* **[FIXED][Free][Pro] Disable Components >> Disable Comments**: fixed PHP warning issue. Props to @ken0429ng for reporting the issue.

* **[FIXED][Free][Pro] Fatal error on site migration**: fixed a fatal error that occurred after migrating a site with ASE configured. Props to Bart van O. and JW for reporting the issue and helping with troubleshooting.

### 6.4.0 (2024.01.15) - ASE Free and Pro

* **[NEW][Pro] Content Management >> Terms Order**: Enable custom ordering of terms from various "hierarchical" taxonomies.

* **[IMPROVED][Pro] Admin Interface >> Admin Columns Manager**: allow extra columns, e.g. from plugins like WPML and Yoast SEO, to use their original title, which sometimes are icons, e.g. language/country flag to signify language, or traffic light to signify SEO score. Props to Sebastian A. for reporting the issue with WPML language column needing to use the original title, which is the language/country flag, different for each enabled languages.

* **[IMPROVED[Pro] Admin Interface >> Admin Columns Manager**: added support for wp_block post type used for all user-created block patterns since WP v6.3. It will allow showing the sync status column added in the 'wp_pattern_sync_status' post meta. Props to Francois G. for suggesting this.

* **[FIXED][Free][Pro] Admin Interface >> Hde Admin Notices**: fixed another PHP warning.

* **[FIXED][Free][Pro] Settings page**: fixed plugin conflicts causing ASE settings page to go blank, i.e. does not work properly. This is usually caused by other plugins loading scripts on ASE settings page that causes some JS error. Two such plugins if active will no longer cause the issue.

* **[FIXED][Free][Pro] Utilities >> Image Sizes Panel**: fixed fatal error in a certain scenario when GamiPress plugin is enabled. Props to Peter J. for reporting the issue complete with the relevant error log entry, which helped with troubleshooting.

* **[FIXED][Free][Pro] Security >> Email Address Obfuscator**: fixed PHP warning on scenarios where user agent is not detectable.

* **[FIXED][Pro] Content Management >> Custom Content Types**: fixed PHP warning during sanitization of checkbox fields during CPT creation / editing. Also fixed PHP warning when trying to detect post type label for the admin column in the Custom Post Types listing page.

[**See the full changelog >>**](https://www.wpase.com/documentation/changelog/)