<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * AudioIgniter Customizer
 *
 * @since 1.0.0
 */
class AudioIgniter_Customizer {

	public function __construct() {
		add_action( 'customize_register', array( $this, 'customize_register' ) );
		add_action( 'wp_head', array( $this, 'customizer_css' ) );
	}

	public function register_scripts() {
		wp_add_inline_style( 'audioigniter', wp_strip_all_tags( $this->generate_styles() ) );
	}

	public function customize_register( $wpc ) {
		$wpc->add_panel( 'audioigniter', array(
			'title' => esc_html_x( 'AudioIgniter', 'customizer section title', 'audioigniter-pro' ),
		) );

		$wpc->add_section( 'audioigniter', array(
			'title' => esc_html_x( 'Appearance', 'customizer section title', 'audioigniter-pro' ),
			'panel' => 'audioigniter',
		) );

		$wpc->add_section( 'audioigniter_soundcloud', array(
			'title' => esc_html_x( 'SoundCloud', 'customizer section title', 'audioigniter-pro' ),
			'panel' => 'audioigniter',
		) );

		$wpc->add_setting( 'audioigniter_disable_typography', array(
			'transport'         => 'postMessage',
			'default'           => '',
			'sanitize_callback' => 'AudioIgniter_Sanitizer::checkbox',
		) );
		$wpc->add_control( 'audioigniter_disable_typography', array(
			'type'        => 'checkbox',
			'section'     => 'audioigniter',
			'label'       => esc_html__( 'Disable the player’s typography', 'audioigniter-pro' ),
			'description' => esc_html__( 'This will disable AudioIgniter’s default typography styles (font family, font weights, line height).', 'audioigniter-pro' ),
		) );

		//
		// General colors
		//

		$wpc->add_setting( 'audioigniter_bg_color', array(
			'default'           => '',
			'sanitize_callback' => 'AudioIgniter_Sanitizer::hex_color',
		) );
		$wpc->add_control( new WP_Customize_Color_Control( $wpc, 'audioigniter_bg_color', array(
			'section' => 'audioigniter',
			'label'   => esc_html__( 'Background Color', 'audioigniter-pro' ),
		) ) );

		$wpc->add_setting( 'audioigniter_bg_image', array(
			'default'           => '',
			'sanitize_callback' => 'esc_url_raw',
		) );
		$wpc->add_control( new WP_Customize_Image_Control( $wpc, 'audioigniter_bg_image', array(
			'section' => 'audioigniter',
			'label'   => esc_html__( 'Background Image', 'audioigniter-pro' ),
		) ) );

		$wpc->add_setting( 'audioigniter_bg_image_repeat', array(
			'default'           => 'no-repeat',
			'sanitize_callback' => 'AudioIgniter_Customizer::sanitize_image_repeat_choices',
		) );
		$wpc->add_control( 'audioigniter_bg_image_repeat', array(
			'type'    => 'select',
			'section' => 'audioigniter',
			'label'   => esc_html__( 'Background Image Repeat', 'audioigniter-pro' ),
			'choices' => self::get_image_repeat_choices(),
		) );

		$wpc->add_setting( 'audioigniter_bg_image_position', array(
			'default'           => 'center',
			'sanitize_callback' => 'AudioIgniter_Customizer::sanitize_image_position_choices',
		) );
		$wpc->add_control( 'audioigniter_bg_image_position', array(
			'type'    => 'select',
			'section' => 'audioigniter',
			'label'   => esc_html__( 'Background Image Position', 'audioigniter-pro' ),
			'choices' => self::get_image_position_choices(),
		) );

		$wpc->add_setting( 'audioigniter_bg_image_cover', array(
			'default'           => 1,
			'sanitize_callback' => 'AudioIgniter_Sanitizer::checkbox',
		) );
		$wpc->add_control( 'audioigniter_bg_image_cover', array(
			'type'    => 'checkbox',
			'section' => 'audioigniter',
			'label'   => esc_html__( 'Resize background image to cover the player', 'audioigniter-pro' ),
		) );

		$wpc->add_setting( 'audioigniter_text_color', array(
			'default'           => '',
			'sanitize_callback' => 'AudioIgniter_Sanitizer::hex_color',
		) );
		$wpc->add_control( new WP_Customize_Color_Control( $wpc, 'audioigniter_text_color', array(
			'section' => 'audioigniter',
			'label'   => esc_html__( 'Text Color', 'audioigniter-pro' ),
		) ) );

		$wpc->add_setting( 'audioigniter_accent_color', array(
			'default'           => '',
			'sanitize_callback' => 'AudioIgniter_Sanitizer::hex_color',
		) );
		$wpc->add_control( new WP_Customize_Color_Control( $wpc, 'audioigniter_accent_color', array(
			'section' => 'audioigniter',
			'label'   => esc_html__( 'Accent Color', 'audioigniter-pro' ),
		) ) );

		$wpc->add_setting( 'audioigniter_text_on_accent_color', array(
			'default'           => '',
			'sanitize_callback' => 'AudioIgniter_Sanitizer::hex_color',
		) );
		$wpc->add_control( new WP_Customize_Color_Control( $wpc, 'audioigniter_text_on_accent_color', array(
			'section' => 'audioigniter',
			'label'   => esc_html__( 'Text Color on Accent', 'audioigniter-pro' ),
		) ) );

		$wpc->add_setting( 'audioigniter_control_color', array(
			'default'           => '',
			'sanitize_callback' => 'AudioIgniter_Sanitizer::hex_color',
		) );
		$wpc->add_control( new WP_Customize_Color_Control( $wpc, 'audioigniter_control_color', array(
			'section' => 'audioigniter',
			'label'   => esc_html__( 'Controls Color', 'audioigniter-pro' ),
		) ) );

		//
		// Player Colors
		//

		$wpc->add_setting( 'audioigniter_player_text_color', array(
			'default'           => '',
			'sanitize_callback' => 'AudioIgniter_Sanitizer::hex_color',
		) );
		$wpc->add_control( new WP_Customize_Color_Control( $wpc, 'audioigniter_player_text_color', array(
			'section' => 'audioigniter',
			'label'   => esc_html__( 'Player Text', 'audioigniter-pro' ),
		) ) );

		$wpc->add_setting( 'audioigniter_player_button_background_color', array(
			'default'           => '',
			'sanitize_callback' => 'AudioIgniter_Sanitizer::hex_color',
		) );
		$wpc->add_control( new WP_Customize_Color_Control( $wpc, 'audioigniter_player_button_background_color', array(
			'section' => 'audioigniter',
			'label'   => esc_html__( 'Player Button Background', 'audioigniter-pro' ),
		) ) );

		$wpc->add_setting( 'audioigniter_player_button_text_color', array(
			'default'           => '',
			'sanitize_callback' => 'AudioIgniter_Sanitizer::hex_color',
		) );
		$wpc->add_control( new WP_Customize_Color_Control( $wpc, 'audioigniter_player_button_text_color', array(
			'section' => 'audioigniter',
			'label'   => esc_html__( 'Player Button Text', 'audioigniter-pro' ),
		) ) );

		$wpc->add_setting( 'audioigniter_player_button_active_background_color', array(
			'default'           => '',
			'sanitize_callback' => 'AudioIgniter_Sanitizer::hex_color',
		) );
		$wpc->add_control( new WP_Customize_Color_Control( $wpc, 'audioigniter_player_button_active_background_color', array(
			'section' => 'audioigniter',
			'label'   => esc_html__( 'Player Active Background', 'audioigniter-pro' ),
		) ) );

		$wpc->add_setting( 'audioigniter_player_button_active_text_color', array(
			'default'           => '',
			'sanitize_callback' => 'AudioIgniter_Sanitizer::hex_color',
		) );
		$wpc->add_control( new WP_Customize_Color_Control( $wpc, 'audioigniter_player_button_active_text_color', array(
			'section' => 'audioigniter',
			'label'   => esc_html__( 'Player Text On Active', 'audioigniter-pro' ),
		) ) );

		//
		// Track & Progress Bar Colors
		//

		$wpc->add_setting( 'audioigniter_track_bar_color', array(
			'default'           => '',
			'sanitize_callback' => 'AudioIgniter_Sanitizer::hex_color',
		) );
		$wpc->add_control( new WP_Customize_Color_Control( $wpc, 'audioigniter_track_bar_color', array(
			'section' => 'audioigniter',
			'label'   => esc_html__( 'Track Bar', 'audioigniter-pro' ),
		) ) );

		$wpc->add_setting( 'audioigniter_progress_bar_color', array(
			'default'           => '',
			'sanitize_callback' => 'AudioIgniter_Sanitizer::hex_color',
		) );
		$wpc->add_control( new WP_Customize_Color_Control( $wpc, 'audioigniter_progress_bar_color', array(
			'section' => 'audioigniter',
			'label'   => esc_html__( 'Progress Bar', 'audioigniter-pro' ),
		) ) );

		//
		// Track & Playlist Colors
		//

		$wpc->add_setting( 'audioigniter_track_background_color', array(
			'default'           => '',
			'sanitize_callback' => 'AudioIgniter_Sanitizer::hex_color',
		) );
		$wpc->add_control( new WP_Customize_Color_Control( $wpc, 'audioigniter_track_background_color', array(
			'section' => 'audioigniter',
			'label'   => esc_html__( 'Track Background', 'audioigniter-pro' ),
		) ) );

		$wpc->add_setting( 'audioigniter_track_text_color', array(
			'default'           => '',
			'sanitize_callback' => 'AudioIgniter_Sanitizer::hex_color',
		) );
		$wpc->add_control( new WP_Customize_Color_Control( $wpc, 'audioigniter_track_text_color', array(
			'section' => 'audioigniter',
			'label'   => esc_html__( 'Track Text', 'audioigniter-pro' ),
		) ) );

		$wpc->add_setting( 'audioigniter_track_active_background_color', array(
			'default'           => '',
			'sanitize_callback' => 'AudioIgniter_Sanitizer::hex_color',
		) );
		$wpc->add_control( new WP_Customize_Color_Control( $wpc, 'audioigniter_track_active_background_color', array(
			'section' => 'audioigniter',
			'label'   => esc_html__( 'Active Track Background', 'audioigniter-pro' ),
		) ) );

		$wpc->add_setting( 'audioigniter_track_active_text_color', array(
			'default'           => '',
			'sanitize_callback' => 'AudioIgniter_Sanitizer::hex_color',
		) );
		$wpc->add_control( new WP_Customize_Color_Control( $wpc, 'audioigniter_track_active_text_color', array(
			'section' => 'audioigniter',
			'label'   => esc_html__( 'Active Track Text', 'audioigniter-pro' ),
		) ) );

		$wpc->add_setting( 'audioigniter_track_button_background_color', array(
			'default'           => '',
			'sanitize_callback' => 'AudioIgniter_Sanitizer::hex_color',
		) );
		$wpc->add_control( new WP_Customize_Color_Control( $wpc, 'audioigniter_track_button_background_color', array(
			'section' => 'audioigniter',
			'label'   => esc_html__( 'Track Button Background', 'audioigniter-pro' ),
		) ) );

		$wpc->add_setting( 'audioigniter_track_button_text_color', array(
			'default'           => '',
			'sanitize_callback' => 'AudioIgniter_Sanitizer::hex_color',
		) );
		$wpc->add_control( new WP_Customize_Color_Control( $wpc, 'audioigniter_track_button_text_color', array(
			'section' => 'audioigniter',
			'label'   => esc_html__( 'Track Button Text', 'audioigniter-pro' ),
		) ) );

		//
		// Lyrics Modal Colors
		//

		$wpc->add_setting( 'audioigniter_lyrics_modal_background_color', array(
			'default'           => '',
			'sanitize_callback' => 'AudioIgniter_Sanitizer::hex_color',
		) );
		$wpc->add_control( new WP_Customize_Color_Control( $wpc, 'audioigniter_lyrics_modal_background_color', array(
			'section' => 'audioigniter',
			'label'   => esc_html__( 'Lyrics Modal Background', 'audioigniter-pro' ),
		) ) );

		$wpc->add_setting( 'audioigniter_lyrics_modal_text_color', array(
			'default'           => '',
			'sanitize_callback' => 'AudioIgniter_Sanitizer::hex_color',
		) );
		$wpc->add_control( new WP_Customize_Color_Control( $wpc, 'audioigniter_lyrics_modal_text_color', array(
			'section' => 'audioigniter',
			'label'   => esc_html__( 'Lyrics Modal Text', 'audioigniter-pro' ),
		) ) );

		//
		// SoundCloud
		//
		$wpc->add_setting( 'audioigniter_sc_client_id', array(
			'sanitize_callback' => 'sanitize_text_field',
			'type'              => 'option',
		) );
		$wpc->add_control( 'audioigniter_sc_client_id', array(
			'type'        => 'text',
			'section'     => 'audioigniter_soundcloud',
			'label'       => esc_html__( 'Application Client ID', 'audioigniter-pro' ),
			'description' => wp_kses( sprintf( __( 'For instructions on how you can generate an Application Client ID, please <a href="%s" target="_blank">read the relevant documentation section.</a>', 'audioigniter-pro' ), 'http://www.cssigniter.com/docs/audioigniter/#scintegration' ), array( 'a' => array( 'href'   => true, 'target' => true ) ) ),
		) );

	}

	public function customizer_css() {
		echo sprintf( '<style type="text/css">%s</style>', wp_strip_all_tags( $this->generate_styles() ) );
	}

	public function generate_styles() {
		ob_start();

		if ( get_theme_mod( 'audioigniter_bg_color' ) ) {
			$bg_color = get_theme_mod( 'audioigniter_bg_color' );
			?>
			.ai-wrap {
				background-color: <?php echo $bg_color; ?>;
			}

			.ai-wrap .ai-volume-bar {
				border-right-color: <?php echo $bg_color; ?>
			}

			.ai-wrap .ai-track-btn,
			.ai-wrap .ai-track-control {
				border-left-color: <?php echo $bg_color; ?>
			}
			<?php
		}

		if ( get_theme_mod( 'audioigniter_bg_image' ) ) {
			?>
			.ai-wrap {
				background-image: url('<?php echo esc_url_raw( get_theme_mod( 'audioigniter_bg_image' ) ); ?>');
				<?php if ( get_theme_mod( 'audioigniter_bg_image_repeat', 'no-repeat' ) ): ?>
					background-repeat: <?php echo get_theme_mod( 'audioigniter_bg_image_repeat', 'no-repeat' ); ?>;
				<?php endif; ?>
				<?php if ( get_theme_mod( 'audioigniter_bg_image_position', 'center' ) ): ?>
					background-position: top <?php echo get_theme_mod( 'audioigniter_bg_image_position', 'center' ); ?>;
				<?php endif; ?>
				<?php if ( get_theme_mod( 'audioigniter_bg_image_cover', 1 ) ): ?>
					background-size: cover;
				<?php endif; ?>
			}
			<?php
		}

		if ( get_theme_mod( 'audioigniter_text_color' ) ) {
			$text_color = get_theme_mod( 'audioigniter_text_color' );
			?>
			.ai-wrap,
			.ai-wrap .ai-btn,
			.ai-wrap .ai-track-btn {
				color: <?php echo $text_color; ?>;
			}

			.ai-wrap .ai-btn svg,
			.ai-wrap .ai-track-no-thumb svg,
			.ai-wrap .ai-track-btn svg {
				fill: <?php echo $text_color; ?>;
			}
			<?php
		}

		if ( get_theme_mod( 'audioigniter_accent_color' ) ) {
			$accent_color = get_theme_mod( 'audioigniter_accent_color' );
			?>
			.ai-wrap .ai-audio-control,
			.ai-wrap .ai-audio-control:hover,
			.ai-wrap .ai-audio-control:focus,
			.ai-wrap .ai-track-progress,
			.ai-wrap .ai-volume-bar.ai-volume-bar-active::before,
			.ai-wrap .ai-track:hover,
			.ai-wrap .ai-track.ai-track-active,
			.ai-wrap .ai-btn.ai-btn-active {
				background-color: <?php echo $accent_color; ?>;
			}

			.ai-wrap .ai-scroll-wrap > div:last-child div {
				background-color: <?php echo $accent_color; ?> !important;
			}

			.ai-wrap .ai-btn:hover,
			.ai-wrap .ai-btn:focus,
			.ai-wrap .ai-footer a,
			.ai-wrap .ai-footer a:hover {
				color: <?php echo $accent_color; ?>;
			}

			.ai-wrap .ai-btn:hover svg,
			.ai-wrap .ai-btn:focus svg  {
				fill: <?php echo $accent_color; ?>;
			}
			<?php
		}

		if ( get_theme_mod( 'audioigniter_text_on_accent_color' ) ) {
			$text_on_accent = get_theme_mod( 'audioigniter_text_on_accent_color' );
			?>
			.ai-wrap .ai-audio-control,
			.ai-wrap .ai-track:hover,
			.ai-wrap .ai-track.ai-track-active,
			.ai-wrap .ai-track.ai-track-active .ai-track-btn,
			.ai-wrap .ai-track:hover .ai-track-btn,
			.ai-wrap .ai-btn.ai-btn-active {
				color: <?php echo $text_on_accent; ?>;
			}

			.ai-wrap .ai-audio-control svg,
			.ai-wrap .ai-track.ai-track-active .ai-track-btn svg,
			.ai-wrap .ai-track:hover .ai-track-btn svg,
			.ai-wrap .ai-btn.ai-btn-active svg {
				fill: <?php echo $text_on_accent; ?>;
			}
			<?php
		}

		if ( get_theme_mod( 'audioigniter_control_color' ) ) {
			$control_color = get_theme_mod( 'audioigniter_control_color' );
			?>
			.ai-wrap .ai-track-progress-bar,
			.ai-wrap .ai-volume-bar,
			.ai-wrap .ai-btn,
			.ai-wrap .ai-btn:hover,
			.ai-wrap .ai-btn:focus,
			.ai-wrap .ai-track,
			.ai-wrap .ai-track-no-thumb {
				background-color: <?php echo $control_color; ?>;
			}

			.ai-wrap .ai-scroll-wrap > div:last-child {
				background-color: <?php echo $control_color; ?>;
			}

			.ai-wrap .ai-footer {
				border-top-color: <?php echo $control_color; ?>;
			}

			.ai-wrap.ai-is-loading .ai-control-wrap-thumb::after,
			.ai-wrap.ai-is-loading .ai-track-title::after,
			.ai-wrap.ai-is-loading .ai-track-subtitle::after {
				background: linear-gradient(to right, <?php echo $control_color; ?> 8%,  <?php echo $this->color_luminance( $control_color, 0.07 ); ?> 18%, <?php echo $control_color; ?> 33%);
			}
			<?php
		}

		//
		// Player Colors
		//

		if ( get_theme_mod( 'audioigniter_player_text_color' ) ) {
			$player_text_color = get_theme_mod( 'audioigniter_player_text_color' );
			?>
			.ai-control-wrap {
			  color: <?php echo $player_text_color; ?>;
			}
			<?php
		}

		if ( get_theme_mod( 'audioigniter_player_button_background_color' ) ) {
			$player_button_background_color = get_theme_mod( 'audioigniter_player_button_background_color' );
			?>
			.ai-control-wrap .ai-btn,
			.ai-control-wrap .ai-btn:hover,
			.ai-player-buttons .ai-btn,
			.ai-player-buttons .ai-btn:hover,
			.ai-wrap .ai-volume-bar {
			  background-color: <?php echo $player_button_background_color; ?>;
			}
			<?php
		}

		if ( get_theme_mod( 'audioigniter_player_button_active_background_color' ) ) {
			$player_button_active_background_color = get_theme_mod( 'audioigniter_player_button_active_background_color' );
			?>
			.ai-control-wrap .ai-audio-control,
			.ai-control-wrap .ai-audio-control:hover,
			.ai-control-wrap .ai-audio-control:focus,
			.ai-control-wrap .ai-btn.ai-btn-active,
			.ai-wrap .ai-volume-bar.ai-volume-bar-active::before {
			  background-color: <?php echo $player_button_active_background_color; ?>;
			}
			<?php
		}

		if ( get_theme_mod( 'audioigniter_player_button_text_color' ) ) {
			$player_button_text_color = get_theme_mod( 'audioigniter_player_button_text_color' );
			?>
			.ai-control-wrap .ai-btn,
			.ai-control-wrap .ai-btn:hover,
			.ai-player-buttons .ai-btn,
			.ai-player-buttons .ai-btn:hover {
				color: <?php echo $player_button_text_color; ?>;
			}

			.ai-control-wrap .ai-btn svg,
			.ai-control-wrap .ai-btn:hover svg {
				fill: <?php echo $player_button_text_color; ?>;
			}
			<?php
		}

		if ( get_theme_mod( 'audioigniter_player_button_active_text_color' ) ) {
			$player_button_active_text_color = get_theme_mod( 'audioigniter_player_button_active_text_color' );
			?>
			.ai-control-wrap .ai-audio-control svg,
			.ai-control-wrap .ai-btn.ai-btn-active svg {
			  fill: <?php echo $player_button_active_text_color; ?>;
			}

			.ai-control-wrap .ai-btn.ai-btn-active {
			  color: <?php echo $player_button_active_text_color; ?>;
			}
			<?php
		}

		//
		// Track & Progress Bar Colors
		//

		if ( get_theme_mod( 'audioigniter_track_bar_color' ) ) {
			$track_bar_color = get_theme_mod( 'audioigniter_track_bar_color' );
			?>
			.ai-wrap .ai-track-progress-bar {
			  background-color: <?php echo $track_bar_color; ?>;
			}
			<?php
		}

		if ( get_theme_mod( 'audioigniter_progress_bar_color' ) ) {
			$progress_bar_color = get_theme_mod( 'audioigniter_progress_bar_color' );
			?>
			.ai-wrap .ai-track-progress {
			  background-color: <?php echo $progress_bar_color; ?>;
			}
			<?php
		}

		//
		// Track & Playlist Colors
		//

		if ( get_theme_mod( 'audioigniter_track_background_color' ) ) {
			$track_background_color = get_theme_mod( 'audioigniter_track_background_color' );
			?>
			.ai-wrap .ai-track {
			  background-color: <?php echo $track_background_color; ?>;
			}
			<?php
		}

		if ( get_theme_mod( 'audioigniter_track_text_color' ) ) {
			$track_text_color = get_theme_mod( 'audioigniter_track_text_color' );
			?>
			.ai-wrap .ai-track,
			.ai-wrap .ai-track-btn {
			  color: <?php echo $track_text_color; ?>;
			}

			.ai-wrap .ai-track-btn svg {
			  fill: <?php echo $track_text_color; ?>;
			}
			<?php
		}

		if ( get_theme_mod( 'audioigniter_track_active_background_color' ) ) {
			$track_text_color = get_theme_mod( 'audioigniter_track_active_background_color' );
			?>
			.ai-wrap .ai-track:hover,
			.ai-wrap .ai-track.ai-track-active {
			  background-color: <?php echo $track_text_color; ?>;
			}
			<?php
		}

		if ( get_theme_mod( 'audioigniter_track_active_text_color' ) ) {
			$track_active_text_color = get_theme_mod( 'audioigniter_track_active_text_color' );
			?>
			.ai-wrap .ai-track:hover,
			.ai-wrap .ai-track.ai-track-active {
			  color: <?php echo $track_active_text_color; ?>;
			}

			.ai-wrap .ai-track:hover .ai-track-btn svg,
			.ai-wrap .ai-track.ai-track-active .ai-track-btn svg {
			  fill: <?php echo $track_active_text_color; ?>;
			}
			<?php
		}

		if ( get_theme_mod( 'audioigniter_track_button_background_color' ) ) {
			$track_button_background_color = get_theme_mod( 'audioigniter_track_button_background_color' );
			?>
			.ai-wrap .ai-track-btn {
			  background-color: <?php echo $track_button_background_color; ?>;
			}
			<?php
		}

		if ( get_theme_mod( 'audioigniter_track_button_text_color' ) ) {
			$track_button_text_color = get_theme_mod( 'audioigniter_track_button_text_color' );
			?>
			.ai-wrap .ai-track-btn {
			  color: <?php echo $track_button_text_color; ?>;
			}

			.ai-wrap .ai-track-btn svg,
			.ai-wrap .ai-track:hover .ai-track-btn svg,
			.ai-wrap .ai-track.ai-track-active .ai-track-btn svg {
			  fill: <?php echo $track_button_text_color; ?>;
			}
			<?php
		}

		//
		// Lyrics Modal Colors
		//

		if ( get_theme_mod( 'audioigniter_lyrics_modal_background_color' ) ) {
			$lyrics_modal_background_color = get_theme_mod( 'audioigniter_lyrics_modal_background_color' );
			?>
			.ai-modal {
			  background-color: <?php echo $lyrics_modal_background_color; ?>;
			}
			<?php
		}

		if ( get_theme_mod( 'audioigniter_lyrics_modal_text_color' ) ) {
			$lyrics_modal_text_color = get_theme_mod( 'audioigniter_lyrics_modal_text_color' );
			?>
			.ai-modal,
			.ai-modal-dismiss,
			.ai-modal-dismiss:hover {
			  color: <?php echo $lyrics_modal_text_color; ?>;
			}
			<?php
		}

		$css = ob_get_clean();

		return apply_filters( 'audioigniter_customizer_generate_styles', $css );
	}

	public static function get_image_repeat_choices() {
		return array(
			'no-repeat' => esc_html__( 'No Repeat', 'audioigniter-pro' ),
			'repeat-x'  => esc_html__( 'Repeat Horizontally', 'audioigniter-pro' ),
			'repeat-y'  => esc_html__( 'Repeat Vertically', 'audioigniter-pro' ),
			'repeat'    => esc_html__( 'Repeat Both', 'audioigniter-pro' ),
		);
	}

	public static function sanitize_image_repeat_choices( $value ) {
		$choices = self::get_image_repeat_choices();
		if ( array_key_exists( $value, $choices ) ) {
			return $value;
		}

		return apply_filters( 'audioigniter_image_repeat_default', 'no-repeat' );
	}

	public static function get_image_position_choices() {
		return array(
			'left'   => esc_html_x( 'Left', 'horizontal position', 'audioigniter-pro' ),
			'center' => esc_html_x( 'Center', 'horizontal position', 'audioigniter-pro' ),
			'right'  => esc_html_x( 'Right', 'horizontal position', 'audioigniter-pro' ),
		);
	}

	public static function sanitize_image_position_choices( $value ) {
		$choices = self::get_image_position_choices();
		if ( array_key_exists( $value, $choices ) ) {
			return $value;
		}

		return apply_filters( 'audioigniter_image_position_default', 'center' );
	}


	/** https://gist.github.com/stephenharris/5532899
	 * Lightens/darkens a given colour (hex format), returning the altered colour in hex format.
	 *
	 * @param $hex string Colour as hexadecimal (with or without hash);
	 * @param float $percent Decimal ( 0.2 = lighten by 20%(), -0.4 = darken by 40%() )
	 *
	 * @return string Lightened/Darkend colour as hexadecimal (with hash);
	 */
	private function color_luminance( $hex, $percent ) {
		// validate hex string
		$hex     = preg_replace( '/[^0-9a-f]/i', '', $hex );
		$new_hex = '#';

		if ( strlen( $hex ) < 6 ) {
			$hex = $hex[0] + $hex[0] + $hex[1] + $hex[1] + $hex[2] + $hex[2];
		}

		// convert to decimal and change luminosity
		for ( $i = 0; $i < 3; $i ++ ) {
			$dec = hexdec( substr( $hex, $i * 2, 2 ) );
			$dec = min( max( 0, $dec + $dec * $percent ), 255 );
			$new_hex .= str_pad( dechex( $dec ), 2, 0, STR_PAD_LEFT );
		}

		return $new_hex;
	}
}
