<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * AudioIgniter Icons
 *
 * @since 1.7.0
 */
class AudioIgniter_Icons {

	/**
	 * @var array[]
	 * @since 1.7.0
	 */
	private $icons = array(
		'amazon'         => array(
			'title' => 'Amazon',
			'svg'   => '<svg width="63" height="64" viewBox="0 0 63 64" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M35.7677 18.6714C28.8105 18.9286 11.5534 20.8857 11.5534 35.4571C11.5534 51.1 31.3105 51.7429 37.7677 41.6286C38.6962 43.0857 42.8248 46.9857 44.2391 48.3143L52.3534 40.3143C52.3534 40.3143 47.7391 36.7 47.7391 32.7714V11.7571C47.7391 8.14286 44.2391 0 31.6962 0C19.1248 0 12.4534 7.85714 12.4534 14.9L22.9534 15.8714C25.2819 8.8 30.6962 8.8 30.6962 8.8C36.5105 8.78571 35.7677 13.0571 35.7677 18.6714V18.6714ZM35.7677 31.0714C35.7677 42.5 23.7391 40.7857 23.7391 33.5286C23.7391 26.7857 30.9534 25.4286 35.7677 25.2714V31.0714V31.0714ZM55.1962 54.4286C54.0962 55.8571 45.1962 64 30.2677 64C15.3391 64 3.91051 53.7857 0.410513 49.5714C-0.560915 48.4714 0.553371 47.9571 1.19623 48.3857C11.6677 54.7429 28.0248 65.2143 54.4105 52.7143C55.4819 52.1857 56.3105 53 55.1962 54.4286ZM60.8819 54.7429C59.9534 57 58.5962 58.5714 57.8534 59.1714C57.0676 59.8143 56.4962 59.5571 56.9248 58.6286C57.3534 57.7 59.6819 51.9857 58.7391 50.7714C57.8105 49.5857 53.4534 50.1571 51.8819 50.3143C50.3391 50.4571 50.0248 50.6 49.8819 50.2714C49.5534 49.4571 52.9819 48.0571 55.2391 47.7714C57.4819 47.5143 61.0962 47.6571 61.8105 48.5857C62.3391 49.3143 61.8105 52.4571 60.8819 54.7429Z" fill="white"/>
</svg>
',
		),
		'apple-music'    => array(
			'title' => 'Apple Music',
			'svg'   => '<svg width="64" height="64" viewBox="0 0 64 64" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M31.9429 6.9C18.4286 6.9 7.5 17.8571 7.5 31.3571C7.5 44.8571 18.4286 55.8286 31.9429 55.8286C45.4571 55.8286 56.4 44.8714 56.4 31.3714C56.4 17.8571 45.4429 6.9 31.9429 6.9V6.9ZM43.2857 41.1857C42.8286 43.1286 41.3571 44.2143 39.3857 44.5857C37.6571 44.9 36.2143 44.9857 34.8286 43.8714C33.1429 42.4429 33.1143 40.1 34.6286 38.6143C35.8286 37.4714 37.5286 37.2429 40.0571 36.7857C40.4857 36.7143 40.8571 36.6143 41.1571 36.2571C41.6143 35.7429 41.4714 35.9714 41.4714 24.7143C41.4714 23.9143 41.0857 23.7 40.2714 23.8429C39.7 23.9429 27.1429 26.2857 27.1429 26.2857C26.4286 26.4429 26.1857 26.6571 26.1857 27.4714C26.1857 44.0571 26.2571 43.3 26.0143 44.4C25.7143 45.6857 24.9286 46.6571 23.8857 47.2C22.7 47.8571 20.5429 48.1429 19.4 47.9429C16.3429 47.3714 15.2714 43.8429 17.3429 41.8143C18.5429 40.6714 20.2429 40.4429 22.7714 39.9857C23.2 39.9143 23.5714 39.8143 23.8714 39.4571C24.5857 38.6429 24 21.3143 24.2429 20.3571C24.3 19.9857 24.4571 19.6714 24.7429 19.4429C25.0429 19.2 25.5714 19.0571 25.7 19.0571C40.1286 16.3429 41.8857 16 42.1429 16C42.9571 15.9429 43.4286 16.4286 43.4286 17.2429C43.4143 41.6143 43.4857 40.3 43.2857 41.1857V41.1857ZM49.3143 0H14.6857C6.55714 0 0 6.55714 0 14.6857V49.3143C0 57.4429 6.55714 64 14.6857 64H49.3143C57.4571 64 64 57.4429 64 49.3143V14.6857C64 6.55714 57.4429 0 49.3143 0ZM31.9429 58.8571C16.7571 58.8571 4.44286 46.5429 4.44286 31.3571C4.44286 16.1714 16.7571 3.85714 31.9429 3.85714C47.1286 3.85714 59.4429 16.1714 59.4429 31.3571C59.4429 46.5429 47.1286 58.8571 31.9429 58.8571Z" fill="white"/>
</svg>
',
		),
		'apple-podcast'  => array(
			'title' => 'Apple Podcast',
			'svg'   => '<svg width="57" height="64" viewBox="0 0 57 64" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M28.98 0C13.5175 0 0.980011 12.5375 0.980011 28C0.980011 39.5275 7.95126 49.425 17.905 53.7125C17.47 51.1188 17.1338 48.5137 17.0303 46.4437C10.99 42.5125 6.98001 35.725 6.98001 28C6.98001 15.8687 16.8488 6 28.98 6C41.1113 6 50.98 15.8687 50.98 28C50.98 35.7238 46.97 42.5125 40.9313 46.45C40.827 48.5125 40.4886 51.1212 40.0519 53.7212C50.005 49.425 56.98 39.525 56.98 28C56.98 12.5375 44.4425 0 28.98 0ZM28.98 39C24.87 39 20.98 40.0781 20.98 44.4688C20.98 48.61 22.59 57.5062 23.5575 61.0687C24.205 63.45 26.6175 64 28.98 64C31.3425 64 33.7613 63.4531 34.4025 61.0775C35.3675 57.4875 36.98 48.6 36.98 44.475C36.98 40.075 33.0925 39 28.98 39ZM28.98 35C32.8488 35 35.98 31.8688 35.98 28C35.98 24.1312 32.7425 21 28.98 21C25.2175 21 21.98 24.125 21.98 28C21.98 31.875 25.105 35 28.98 35ZM46.98 28C46.98 18.0588 38.9213 10 28.98 10C19.0388 10 10.98 18.0625 10.98 28C10.98 33.6038 13.595 38.5475 17.61 41.85C18.2171 40.2687 19.3763 38.615 21.6163 37.47C21.6175 37.4625 21.655 37.4625 21.68 37.4625C18.8425 35.2625 16.98 31.8625 16.98 28C16.98 21.3725 22.3525 16 28.98 16C35.6075 16 40.98 21.3725 40.98 28C40.98 31.865 39.1213 35.2662 36.2838 37.46C36.3001 37.4632 36.3472 37.4661 36.3431 37.4693C38.5843 38.6143 39.7418 40.2668 40.3493 41.8493C44.3675 38.55 46.98 33.6 46.98 28Z" fill="white"/>
</svg>
',
		),
		'bandcamp'       => array(
			'title' => 'Bandcamp',
			'svg'   => '<svg width="65" height="64" viewBox="0 0 65 64" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M32.96 0C15.2826 0 0.960022 14.3226 0.960022 32C0.960022 49.6774 15.2826 64 32.96 64C50.6374 64 64.96 49.6774 64.96 32C64.96 14.3226 50.6374 0 32.96 0ZM39.1794 42.0774H15.8245L26.7536 21.9355H50.1084L39.1794 42.0774Z" fill="white"/>
</svg>
',
		),
		'castbox'        => array(
			'title' => 'Castbox',
			'svg'   => '<svg width="57" height="64" viewBox="0 0 57 64" fill="none" xmlns="http://www.w3.org/2000/svg">
<path fill-rule="evenodd" clip-rule="evenodd" d="M26.4714 0.549375C27.7095 -0.183125 29.5674 -0.183125 30.8055 0.549375L54.1924 14.3794C55.418 15.1044 56.3356 16.7106 56.3356 18.1331V45.8644C56.3356 47.2869 55.418 48.8931 54.1924 49.6181L30.8055 63.4506C29.5674 64.1831 27.7108 64.1831 26.4714 63.4506L3.0833 49.6181C1.85768 48.8931 0.940033 47.2869 0.940033 45.8644V18.1331C0.940033 16.7106 1.85768 15.1044 3.0833 14.3794L26.4714 0.549375ZM32.4555 23.7169C31.4064 23.7169 30.5551 24.5231 30.5551 25.5181V29.8781C30.5551 30.4294 30.0444 30.8756 29.4146 30.8756C28.7849 30.8756 28.2742 30.4294 28.2742 29.8781V23.9469C28.2742 22.9506 27.4229 22.1444 26.3738 22.1444C25.3234 22.1444 24.4734 22.9506 24.4734 23.9469V28.7006C24.4734 29.2506 23.9626 29.6981 23.3329 29.6981C22.7044 29.6981 22.1936 29.2506 22.1936 28.7006V26.9781C22.1936 25.9831 21.3424 25.1756 20.2933 25.1756C19.2429 25.1756 18.3929 25.9819 18.3929 26.9781V31.0569C18.3929 31.6069 17.8821 32.0544 17.2524 32.0544C16.6239 32.0544 16.1131 31.6069 16.1131 31.0569V30.5831C16.1131 29.5419 15.2618 28.6969 14.2127 28.6969C13.1624 28.6969 12.3124 29.5419 12.3124 30.5831V36.2444C12.3124 37.2856 13.1624 38.1319 14.2127 38.1319C15.2618 38.1319 16.1131 37.2869 16.1131 36.2444V35.7706C16.1131 35.2206 16.6239 34.7731 17.2524 34.7731C17.8821 34.7731 18.3929 35.2206 18.3929 35.7706V42.2419C18.3929 43.2369 19.2429 44.0444 20.2933 44.0444C21.3424 44.0444 22.1936 43.2369 22.1936 42.2419V33.4144C22.1936 32.8644 22.7044 32.4169 23.3329 32.4169C23.9626 32.4169 24.4734 32.8644 24.4734 33.4144V37.8619C24.4734 38.8581 25.3234 39.6644 26.3738 39.6644C27.4229 39.6644 28.2742 38.8581 28.2742 37.8619V34.5919C28.2742 34.0419 28.7849 33.5944 29.4146 33.5944C30.0431 33.5944 30.5551 34.0419 30.5551 34.5919V38.0869C30.5551 39.0819 31.4064 39.8894 32.4555 39.8894C33.5059 39.8894 34.3559 39.0831 34.3559 38.0869V25.5181C34.3559 24.5231 33.5059 23.7169 32.4555 23.7169ZM38.5373 28.5856C37.4882 28.5856 36.6369 29.3919 36.6369 30.3881V37.5656C36.6369 38.5606 37.4869 39.3681 38.5373 39.3681C39.5864 39.3681 40.4377 38.5619 40.4377 37.5656V30.3881C40.4364 29.3919 39.5851 28.5856 38.5373 28.5856ZM44.6178 32.2356C43.5687 32.2356 42.7174 33.0419 42.7174 34.0381V35.8244C42.7174 36.8194 43.5687 37.6269 44.6178 37.6269C45.6681 37.6269 46.5182 36.8206 46.5182 35.8244V34.0381C46.5182 33.0419 45.6681 32.2356 44.6178 32.2356Z" fill="white"/>
</svg>
',
		),
		'deezer'         => array(
			'title' => 'Deezer',
			'svg'   => '<svg width="98" height="64" viewBox="0 0 98 64" fill="none" xmlns="http://www.w3.org/2000/svg">
<rect x="26.0081" y="17.4375" width="20.9095" height="12.5625" />
<rect x="26.0081" y="34.424" width="20.9095" height="12.5625" />
<rect x="26.0081" y="51.0501" width="20.9095" height="12.5625" />
<rect x="51.2716" y="51.0501" width="20.9095" height="12.5625" />
<rect x="51.2716" y="34.424" width="20.9095" height="12.5625" />
<rect x="76.5426" y="34.424" width="20.9095" height="12.5625" />
<rect x="76.5426" y="51.0501" width="20.9095" height="12.5625" />
<rect x="76.5426" y="17.4375" width="20.9095" height="12.5625" />
<rect x="76.5426" y="0.437927" width="20.9095" height="12.5625" />
<rect x="0.744995" y="51.0501" width="20.9095" height="12.5625" />
</svg>
',
		),
		'download'       => array(
			'title' => 'Download',
			'svg'   => '<svg width="65" height="64" viewBox="0 0 65 64" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M60.9799 44H44.2924L38.6361 49.6562C37.1299 51.1625 35.1174 52 32.9799 52C30.8424 52 28.8349 51.168 27.3236 49.6562L21.6674 44H4.97986C2.77111 44 0.979858 45.7912 0.979858 48V60C0.979858 62.2088 2.77111 64 4.97986 64H60.9799C63.1886 64 64.9799 62.2088 64.9799 60V48C64.9799 45.7875 63.1924 44 60.9799 44ZM54.9799 57C53.3299 57 51.9799 55.65 51.9799 54C51.9799 52.35 53.3299 51 54.9799 51C56.6299 51 57.9799 52.35 57.9799 54C57.9799 55.65 56.6299 57 54.9799 57ZM30.1549 46.825C30.9299 47.6125 31.9549 48 32.9799 48C34.0049 48 35.0274 47.6094 35.8074 46.8281L51.8074 30.8281C53.3686 29.2656 53.3686 26.7344 51.8074 25.1719C50.2449 23.6094 47.7124 23.6094 46.1511 25.1719L36.9799 34.35V4C36.9799 1.79125 35.1886 0 32.9799 0C30.7674 0 28.9799 1.79125 28.9799 4V34.35L19.8049 25.175C18.2436 23.6125 15.7111 23.6125 14.1486 25.175C12.5874 26.7375 12.5874 29.2687 14.1486 30.8312L30.1549 46.825Z" fill="white"/>
</svg>
',
		),
		'google-podcast' => array(
			'title' => 'Google Podcast',
			'svg'   => '<svg width="64" height="65" viewBox="0 0 64 65" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M4 26.2694C1.792 26.2694 0 28.0614 0 30.2694V34.6134C0 39.9474 8 39.9474 8 34.6134V30.2694C8 28.0614 6.208 26.2694 4 26.2694V26.2694ZM60 26.2694C57.792 26.2694 56 28.0614 56 30.2694V34.6134C56 39.9474 64 39.9474 64 34.6134V30.2694C64 28.0614 62.208 26.2694 60 26.2694V26.2694ZM17.812 39.3634C15.604 39.3634 13.812 41.1554 13.812 43.3634V47.7074C13.812 53.0414 21.812 53.0414 21.812 47.7074V43.3954C21.812 41.1774 20.03 39.3954 17.812 39.3954V39.3634ZM17.812 13.1754C15.604 13.1754 13.812 14.9674 13.812 17.1754V31.4674C13.812 36.8014 21.812 36.8014 21.812 31.4674V17.1554C21.812 14.9374 20.03 13.1554 17.812 13.1554V13.1754ZM46.188 13.1754C43.97 13.1754 42.188 14.9674 42.188 17.1754V21.5514C42.188 26.8854 50.188 26.8854 50.188 21.5514V17.1754C50.188 14.9674 48.396 13.1754 46.188 13.1754ZM32 0.457397C29.792 0.457397 28 2.2494 28 4.4574V8.8014C28 14.1354 36 14.1354 36 8.8014V4.4574C36 2.2494 34.208 0.457397 32 0.457397V0.457397ZM32 52.0834C29.792 52.0834 28 53.8754 28 56.0834V60.4594C27.98 65.7934 35.98 65.8234 36 60.4914V56.1154C36 53.9274 34.208 52.1154 32 52.1154V52.0834ZM46.188 29.5194C43.97 29.5194 42.188 31.3314 42.188 33.5194V47.7374C42.188 53.0714 50.188 53.0714 50.188 47.7374V33.5194C50.188 31.3114 48.396 29.5194 46.188 29.5194V29.5194ZM32 16.8014C29.792 16.8014 28 18.6134 28 20.8014V44.0834C28 49.4174 36 49.4174 36 44.0834V20.8334C36 18.6154 34.208 16.8334 32 16.8334V16.8014Z" fill="white"/>
</svg>
',
		),
		'iheart'         => array(
			'title' => 'iHeart',
			'svg'   => '<svg width="88" height="65" viewBox="0 0 88 65" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M24.3209 0.457397C11.2965 0.457397 0.744019 11.0093 0.744019 24.0327C0.744019 32.2956 5.97645 38.2524 11.4432 43.7649L32.8187 63.9739C33.9387 65.0328 35.7815 64.2381 35.7815 62.6967V46.9522C35.7815 42.3969 39.4699 38.7026 44.0239 38.6952C48.5774 38.7027 52.2679 42.3969 52.2679 46.9522V62.6967C52.2679 64.2381 54.1107 65.0328 55.2307 63.9739L76.6046 43.7649C82.0715 38.2524 87.3054 32.2952 87.3054 24.0327C87.3054 11.0099 76.7548 0.45828 63.7301 0.457397H63.7285C55.5559 0.457981 48.2539 4.7874 44.0255 11.111C39.7967 4.78729 32.4949 0.457397 24.3209 0.457397H24.3209ZM18.685 7.652C19.2098 7.66949 19.7152 7.94016 20.0142 8.41832C20.4941 9.18053 20.2632 10.1903 19.4985 10.6701C15.8373 12.9651 12.9709 18.3441 12.9709 22.9149V22.9946C12.9709 28.625 16.1706 34.3152 22.4808 39.9057C23.158 40.5055 23.2196 41.538 22.6223 42.2128C22.2991 42.5776 21.8486 42.7611 21.3988 42.7611C21.0131 42.7611 20.6268 42.6276 20.3152 42.3527C13.2761 36.1125 9.70554 29.6005 9.70554 22.9946V22.9149C9.70554 17.2387 13.1708 10.7832 17.7625 7.90093C18.049 7.72183 18.3709 7.64117 18.685 7.652ZM69.3644 7.652C69.6793 7.64117 70.0004 7.7218 70.287 7.90093C74.8794 10.7832 78.3439 17.2387 78.3439 22.9149V22.9946C78.3439 29.6005 74.7741 36.1125 67.7342 42.3527C67.4235 42.6276 67.0363 42.7611 66.6506 42.7611C66.2016 42.7611 65.7503 42.5776 65.4271 42.2128C64.8282 41.538 64.8906 40.5055 65.567 39.9057C71.8772 34.3152 75.0768 28.625 75.0768 22.9946V22.9149C75.0768 18.3441 72.2096 12.9635 68.5493 10.6685C67.7846 10.1886 67.5554 9.18053 68.0352 8.41832C68.3342 7.94016 68.8405 7.66949 69.3644 7.652V7.652ZM30.5881 11.8285C31.2229 11.7752 31.8555 12.0976 32.1712 12.6957C32.591 13.4946 32.2859 14.4812 31.4862 14.9019C28.2133 16.6238 26.1759 19.9844 26.1675 23.6763C26.1767 27.6932 28.722 31.8097 32.5031 33.9281C33.2911 34.3671 33.571 35.3634 33.1311 36.1506C32.8321 36.6845 32.2773 36.9868 31.7059 36.9868C31.4335 36.9868 31.1594 36.9202 30.907 36.7786C26.1346 34.1062 22.9214 28.8563 22.9005 23.7024V23.6536C22.9197 18.752 25.6216 14.2949 29.965 12.0107C30.1649 11.9058 30.3765 11.8468 30.5881 11.8285V11.8285ZM57.4613 11.8285C57.6729 11.8468 57.8853 11.9057 58.0844 12.0107C62.4278 14.2949 65.1289 18.752 65.1489 23.6536V23.7024C65.1281 28.8563 61.9148 34.1062 57.1424 36.7786C56.89 36.9202 56.616 36.9869 56.3436 36.9869C55.7721 36.9869 55.2166 36.6845 54.9167 36.1506C54.4768 35.3634 54.7583 34.3671 55.5463 33.9281C59.3283 31.8097 61.8702 27.6932 61.8802 23.6764C61.8719 19.9844 59.837 16.6238 56.5632 14.9019C55.7643 14.4813 55.4559 13.4946 55.8766 12.6957C56.1915 12.0976 56.8274 11.7752 57.4613 11.8285V11.8285ZM44.0239 17.798C47.9383 17.8005 51.1111 20.9741 51.1111 24.8885C51.1111 28.8028 47.9383 31.9764 44.0239 31.9789C40.1103 31.9764 36.9383 28.8028 36.9383 24.8885C36.9383 20.9741 40.1103 17.8005 44.0239 17.798Z" fill="white"/>
</svg>
',
		),
		'overcast'       => array(
			'title' => 'Overcast',
			'svg'   => '<svg width="65" height="64" viewBox="0 0 65 64" fill="none" xmlns="http://www.w3.org/2000/svg">
<path fill-rule="evenodd" clip-rule="evenodd" d="M32.3542 64C14.6206 64 0.354248 49.7336 0.354248 32C0.354248 14.2664 14.6206 3.05176e-05 32.3542 3.05176e-05C50.0878 3.05176e-05 64.3542 14.2664 64.3542 32C64.3542 49.7336 50.0878 64 32.3542 64ZM32.3542 51.3336L34.7542 48.9336L32.3542 39.7336L29.9542 48.9336L32.3542 51.3336ZM29.2878 51.2L28.0878 55.7336L30.8878 52.9336L29.2878 51.2ZM35.4206 51.2L33.8206 52.8L36.6206 55.6L35.4206 51.2ZM37.6878 59.4664L32.3542 54.1336L27.0206 59.4664C28.7542 59.7336 30.4878 60 32.3542 60C34.2206 60 35.9542 59.8664 37.6878 59.4664ZM32.3542 4.00003C16.8878 4.00003 4.35425 16.5336 4.35425 32C4.35425 44.2664 12.2206 54.6664 23.1542 58.4L29.1542 36.1336C27.8206 35.2 27.0206 33.6 27.0206 31.8664C27.0206 28.9336 29.4206 26.5336 32.3542 26.5336C35.2878 26.5336 37.6878 28.9336 37.6878 31.8664C37.6878 33.6 36.8878 35.0664 35.5542 36.1336L41.5542 58.4C52.4878 54.6664 60.3542 44.2664 60.3542 32C60.3542 16.5336 47.8206 4.00003 32.3542 4.00003ZM50.6206 45.8664C49.9542 46.6664 48.7542 46.9336 47.8206 46.2664C46.8878 45.6 46.7542 44.4 47.4206 43.6C47.4206 43.6 51.0206 38.8 51.0206 32C51.0206 25.2 47.4206 20.4 47.4206 20.4C46.7542 19.6 46.8878 18.4 47.8206 17.7336C48.7542 17.0664 49.9542 17.3336 50.6206 18.1336C50.8878 18.4 55.0206 23.8664 55.0206 32C55.0206 40.1336 50.8878 45.6 50.6206 45.8664ZM40.8878 40.6664C40.0878 39.8664 40.2206 38.4 41.0206 37.6C41.0206 37.6 43.0206 35.4664 43.0206 32C43.0206 28.5336 41.0206 26.5336 41.0206 26.4C40.2206 25.6 40.2206 24.2664 40.8878 23.3336C41.6878 22.4 42.8878 22.4 43.6878 23.2C43.8206 23.3336 47.0206 26.6664 47.0206 32C47.0206 37.3336 43.8206 40.6664 43.6878 40.8C42.8878 41.6 41.6878 41.4664 40.8878 40.6664ZM23.8206 40.6664C23.0206 41.4664 21.8206 41.6 21.0206 40.8C20.8878 40.5336 17.6878 37.3336 17.6878 32C17.6878 26.6664 20.8878 23.4664 21.0206 23.2C21.8206 22.4 23.1542 22.4 23.8206 23.3336C24.6206 24.1336 24.4878 25.6 23.6878 26.4C23.6878 26.5336 21.6878 28.5336 21.6878 32C21.6878 35.4664 23.6878 37.6 23.6878 37.6C24.4878 38.4 24.6206 39.7336 23.8206 40.6664ZM16.8878 46.2664C15.9542 46.9336 14.7542 46.6664 14.0878 45.8664C13.8206 45.6 9.68785 40.1336 9.68785 32C9.68785 23.8664 13.8206 18.4 14.0878 18.1336C14.7542 17.3336 15.9542 17.0664 16.8878 17.7336C17.8206 18.4 17.9542 19.6 17.2878 20.4C17.2878 20.4 13.6878 25.2 13.6878 32C13.6878 38.8 17.2878 43.6 17.2878 43.6C17.9542 44.4 17.6878 45.6 16.8878 46.2664Z" fill="white"/>
</svg>
',
		),
		'patreon'        => array(
			'title' => 'Patreon',
			'svg'   => '<svg width="68" height="64" viewBox="0 0 68 64" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M43.3843 47.9801C56.6336 47.9801 67.3743 37.2394 67.3743 23.99C67.3743 10.7407 56.6336 0 43.3843 0C30.135 0 19.3943 10.7407 19.3943 23.99C19.3943 37.2394 30.135 47.9801 43.3843 47.9801Z" fill="white"/>
<path d="M12.5932 0H0.86731V64H12.5932V0Z" fill="white"/>
</svg>
',
		),
		'rss'            => array(
			'title' => 'RSS',
			'svg'   => '<svg width="65" height="64" viewBox="0 0 65 64" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M8.88733 0C6.7656 0 4.73077 0.842855 3.23047 2.34315C1.73018 3.84344 0.887329 5.87827 0.887329 8L0.887329 56C0.887329 58.1217 1.73018 60.1566 3.23047 61.6569C4.73077 63.1571 6.7656 64 8.88733 64H56.8873C59.0091 64 61.0439 63.1571 62.5442 61.6569C64.0445 60.1566 64.8873 58.1217 64.8873 56V8C64.8873 5.87827 64.0445 3.84344 62.5442 2.34315C61.0439 0.842855 59.0091 0 56.8873 0L8.88733 0ZM14.8873 10C36.9793 10 54.8873 27.908 54.8873 50C54.8873 51.0609 54.4659 52.0783 53.7158 52.8284C52.9656 53.5786 51.9482 54 50.8873 54C49.8265 54 48.809 53.5786 48.0589 52.8284C47.3088 52.0783 46.8873 51.0609 46.8873 50C46.8873 41.5131 43.5159 33.3737 37.5147 27.3726C31.5136 21.3714 23.3743 18 14.8873 18C13.8265 18 12.809 17.5786 12.0589 16.8284C11.3088 16.0783 10.8873 15.0609 10.8873 14C10.8873 12.9391 11.3088 11.9217 12.0589 11.1716C12.809 10.4214 13.8265 10 14.8873 10V10ZM14.8873 26C21.2525 26 27.357 28.5286 31.8579 33.0294C36.3588 37.5303 38.8873 43.6348 38.8873 50C38.8873 51.0609 38.4659 52.0783 37.7158 52.8284C36.9656 53.5786 35.9482 54 34.8873 54C33.8265 54 32.809 53.5786 32.0589 52.8284C31.3088 52.0783 30.8873 51.0609 30.8873 50C30.8873 45.7565 29.2016 41.6869 26.201 38.6863C23.2005 35.6857 19.1308 34 14.8873 34C13.8265 34 12.809 33.5786 12.0589 32.8284C11.3088 32.0783 10.8873 31.0609 10.8873 30C10.8873 28.9391 11.3088 27.9217 12.0589 27.1716C12.809 26.4214 13.8265 26 14.8873 26V26ZM16.8873 54C15.296 54 13.7699 53.3679 12.6447 52.2426C11.5195 51.1174 10.8873 49.5913 10.8873 48C10.8873 46.4087 11.5195 44.8826 12.6447 43.7574C13.7699 42.6321 15.296 42 16.8873 42C18.4786 42 20.0048 42.6321 21.13 43.7574C22.2552 44.8826 22.8873 46.4087 22.8873 48C22.8873 49.5913 22.2552 51.1174 21.13 52.2426C20.0048 53.3679 18.4786 54 16.8873 54Z" fill="white"/>
</svg>
',
		),
		'soundcloud'     => array(
			'title' => 'SoundCloud',
			'svg'   => '<svg width="81" height="36" viewBox="0 0 81 36" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M14.8448 18.0313L15.5698 26.1563L14.8448 34.6938C14.8073 35.0063 14.5698 35.2438 14.2948 35.2438C14.0198 35.2438 13.7698 35.0063 13.7698 34.6938L13.0698 26.1563L13.7698 18.0313C13.7698 17.7563 14.0073 17.5063 14.2948 17.5063C14.5698 17.5063 14.8073 17.7563 14.8448 18.0313ZM17.5198 12.3313C17.1698 12.3313 16.9323 12.6063 16.8948 12.9563L16.2698 26.1563L16.8948 34.6938C16.9323 35.0438 17.1698 35.3188 17.5198 35.3188C17.8323 35.3188 18.1073 35.0438 18.1073 34.6938L18.8323 26.1563L18.1073 12.9563C18.1073 12.6063 17.8323 12.3313 17.5198 12.3313ZM20.7073 9.31879C20.3198 9.31879 20.0448 9.59379 20.0073 9.98129L19.4573 26.2313L20.0073 34.7063C20.0448 35.0938 20.3198 35.3688 20.7073 35.3688C21.0573 35.3688 21.3698 35.0938 21.3698 34.7063L22.0323 26.2313L21.3698 9.98129C21.3698 9.59379 21.0573 9.31879 20.7073 9.31879ZM1.8198 21.3938C1.6448 21.3938 1.5448 21.5313 1.5073 21.7063L0.9198 26.1563L1.5073 30.5313C1.5448 30.7063 1.6448 30.8438 1.8198 30.8438C1.9948 30.8438 2.0948 30.7063 2.1323 30.5313L2.8323 26.1563L2.1323 21.7063C2.0948 21.5313 1.9948 21.3938 1.8198 21.3938V21.3938ZM4.7698 18.6563C4.5948 18.6563 4.4573 18.7938 4.4573 18.9688L3.6573 26.1563L4.4573 33.1688C4.4573 33.3813 4.5948 33.5188 4.7698 33.5188C4.9448 33.5188 5.0823 33.3813 5.1198 33.2063L6.0198 26.1563L5.1198 18.9688C5.0823 18.7938 4.9448 18.6563 4.7698 18.6563V18.6563ZM7.9323 17.2313C7.7198 17.2313 7.5448 17.4063 7.5198 17.6438L6.7948 26.1563L7.5198 34.3813C7.5573 34.5938 7.7323 34.7688 7.9323 34.7688C8.1448 34.7688 8.3198 34.5938 8.3198 34.3813L9.1823 26.1563L8.3198 17.6438C8.3198 17.4063 8.1448 17.2313 7.9323 17.2313V17.2313ZM11.0948 16.9563C10.8573 16.9563 10.6448 17.1313 10.6448 17.4063L9.9198 26.1563L10.6448 34.6313C10.6448 34.9063 10.8573 35.0813 11.0948 35.0813C11.3323 35.0813 11.5448 34.9063 11.5823 34.6313L12.3823 26.1563L11.5823 17.4063C11.5448 17.1313 11.3323 16.9563 11.0948 16.9563ZM41.2698 3.09379C41.1323 2.99379 40.9198 2.91879 40.7448 2.91879C40.4698 2.91879 40.2198 3.01879 40.0448 3.15629C39.8073 3.36879 39.6573 3.68129 39.6323 3.99379V4.09379L39.2198 26.1813L39.4323 30.2438L39.6448 34.2063C39.6823 34.7938 40.1698 35.2813 40.7573 35.2813C41.3448 35.2813 41.8323 34.7938 41.8323 34.2063L42.3198 26.1813L41.8323 3.99379C41.7823 3.61879 41.5823 3.26879 41.2698 3.09379V3.09379ZM37.9323 5.00629C37.7573 4.90629 37.5823 4.83129 37.3823 4.83129C37.1823 4.83129 36.9948 4.90629 36.8323 5.00629C36.5573 5.18129 36.3823 5.49379 36.3823 5.84379L36.3448 6.05629L35.9948 26.1563C35.9948 26.1563 35.9948 26.1938 36.3823 34.3563V34.3938C36.3823 34.6063 36.4573 34.8063 36.5948 34.9813C36.8073 35.2188 37.0823 35.3688 37.3948 35.3688C37.6698 35.3688 37.9198 35.2313 38.0948 35.0563C38.3073 34.8813 38.4073 34.6438 38.4073 34.3563L38.4448 33.5188L38.8323 26.1938L38.4198 5.84379C38.3823 5.49379 38.2073 5.18129 37.9323 5.00629V5.00629ZM24.0073 7.81879C23.6198 7.81879 23.2823 8.16879 23.2823 8.58129L22.7323 26.1563L23.2823 34.5563C23.3198 34.9688 23.6323 35.2813 24.0073 35.2813C24.4198 35.2813 24.7323 34.9688 24.7698 34.5563L25.3948 26.1563L24.7698 8.58129C24.7448 8.16879 24.4323 7.81879 24.0073 7.81879ZM71.0948 15.6688C69.7448 15.6688 68.4573 15.9438 67.2698 16.4313C66.4698 7.58129 59.0448 0.631287 49.9823 0.631287C47.7573 0.631287 45.6073 1.04379 43.6948 1.80629C42.9323 2.08129 42.7198 2.35629 42.7198 2.95629V34.1688C42.7198 34.7938 43.2073 35.2438 43.7948 35.3188H71.0823C76.4948 35.3188 80.9073 30.9438 80.9073 25.5313C80.9198 20.0813 76.5073 15.6688 71.0948 15.6688V15.6688ZM34.0073 8.13129C33.4823 8.13129 33.0698 8.54379 33.0323 9.10629L32.6198 26.1938L33.0323 34.3938C33.0698 34.9188 33.4823 35.3313 34.0073 35.3313C34.5323 35.3313 34.9448 34.9188 34.9448 34.3938L35.4323 26.1938L34.9448 9.10629C34.9073 8.54379 34.5323 8.13129 34.0073 8.13129ZM27.3073 7.15629C26.8948 7.15629 26.5073 7.54379 26.5073 7.99379L26.0198 26.1563L26.5073 34.5188C26.5448 34.9688 26.8948 35.3188 27.3073 35.3188C27.7573 35.3188 28.1073 34.9688 28.1448 34.5188L28.6948 26.1563L28.1448 7.99379C28.1073 7.54379 27.7573 7.15629 27.3073 7.15629V7.15629ZM30.6448 7.58129C30.1573 7.58129 29.7823 7.96879 29.7823 8.44379L29.2948 26.1563L29.7823 34.4563C29.8198 34.9438 30.1698 35.3188 30.6448 35.3188C31.1198 35.3188 31.5073 34.9313 31.5073 34.4563L32.0323 26.1563L31.5073 8.44379C31.5073 7.95629 31.1323 7.58129 30.6448 7.58129V7.58129Z" fill="white"/>
</svg>
',
		),
		'spotify'        => array(
			'title' => 'Spotify',
			'svg'   => '<svg width="63" height="62" viewBox="0 0 63 62" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M31.9398 0C14.8273 0 0.939819 13.8875 0.939819 31C0.939819 48.1125 14.8273 62 31.9398 62C49.0523 62 62.9398 48.1125 62.9398 31C62.9398 13.8875 49.0523 0 31.9398 0ZM44.5273 45.6125C44.0023 45.6125 43.6773 45.45 43.1898 45.1625C35.3898 40.4625 26.3148 40.2625 17.3523 42.1C16.8648 42.225 16.2273 42.425 15.8648 42.425C14.6523 42.425 13.8898 41.4625 13.8898 40.45C13.8898 39.1625 14.6523 38.55 15.5898 38.35C25.8273 36.0875 36.2898 36.2875 45.2148 41.625C45.9773 42.1125 46.4273 42.55 46.4273 43.6875C46.4273 44.825 45.5398 45.6125 44.5273 45.6125V45.6125ZM47.8898 37.4125C47.2398 37.4125 46.8023 37.125 46.3523 36.8875C38.5398 32.2625 26.8898 30.4 16.5273 33.2125C15.9273 33.375 15.6023 33.5375 15.0398 33.5375C13.7023 33.5375 12.6148 32.45 12.6148 31.1125C12.6148 29.775 13.2648 28.8875 14.5523 28.525C18.0273 27.55 21.5773 26.825 26.7773 26.825C34.8898 26.825 42.7273 28.8375 48.9023 32.5125C49.9148 33.1125 50.3148 33.8875 50.3148 34.975C50.3023 36.325 49.2523 37.4125 47.8898 37.4125V37.4125ZM51.7648 27.8875C51.1148 27.8875 50.7148 27.725 50.1523 27.4C41.2523 22.0875 25.3398 20.8125 15.0398 23.6875C14.5898 23.8125 14.0273 24.0125 13.4273 24.0125C11.7773 24.0125 10.5148 22.725 10.5148 21.0625C10.5148 19.3625 11.5648 18.4 12.6898 18.075C17.0898 16.7875 22.0148 16.175 27.3773 16.175C36.5023 16.175 46.0648 18.075 53.0523 22.15C54.0273 22.7125 54.6648 23.4875 54.6648 24.975C54.6648 26.675 53.2898 27.8875 51.7648 27.8875V27.8875Z" fill="white"/>
</svg>
',
		),
		'stitcher'       => array(
			'title' => 'Stitcher',
			'svg'   => '<svg width="65" height="28" viewBox="0 0 65 28" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M53.1998 4.70936H64.9598V23.184H53.1998V4.70936ZM0.959839 5.6107H12.7198V26.4187H0.959839V5.6107ZM14.0638 2.06936H25.7652V24.928H14.0638V2.06936ZM27.1092 4.0027H38.8105V27.496H27.1092V4.0027ZM40.1545 0.504028H51.8558V24.9254H40.1545V0.504028Z" fill="white"/>
</svg>
',
		),
	);

	/**
	 * Returns the SVG of an icon.
	 *
	 * @since 1.7.0
	 *
	 * @param string $icon The icon name, e.g. 'spotify'
	 */
	public function get_svg( $icon ) {
		return $this->icons[ $icon ]['svg'];
	}

	/**
	 * Returns the options HTML for a select element.
	 *
	 * @since 1.7.0
	 *
	 * @param string $selected_icon The icon to be marked as selected.
	 */
	public function get_dropdown_options( $selected_icon ) {
		$options = array();
		foreach ( $this->icons as $icon_slug => $icon ) {
			$options[] = sprintf( '<option value="%s" %s>%s</option>',
				$icon_slug,
				selected( $icon_slug, $selected_icon, false ),
				$icon['title']
			);
		}

		return implode( PHP_EOL, $options );
	}
}
