<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * AudioIgniter Visual Composer Playlist
 * @since 1.0
 */
class AudioIgniter_Visual_Composer_Playlist implements Vc_Vendor_Interface {

	/**
	 * Implement interface, map AudioIgniter shortcode
	 * @since 1.0
	 */
	public function load() {
		vc_map( $this->addShortcodeSettings() );
	}

	/**
	 * Mapping settings.
	 *
	 * @since 1.0
	 *
	 * @return array
	 */
	public function addShortcodeSettings() {
		$playlists = AudioIgniter()->get_all_playlists();

		$values = array();
		foreach ( $playlists as $playlist ) {
			$values[ $playlist->post_title ] = $playlist->ID;
		}

		return array(
			'base'        => 'ai_playlist',
			'name'        => __( 'AudioIgniter Playlist', 'audioigniter-pro' ),
			'icon'        => AudioIgniter()->plugin_url() . 'assets/images/vc_icon.png',
			'category'    => __( 'Test Content', 'audioigniter-pro' ),
			'description' => __( 'AudioIgniter Playlist Player', 'audioigniter-pro' ),
			'params'      => array(
				array(
					'type'        => 'dropdown',
					'heading'     => __( 'Playlist', 'audioigniter-pro' ),
					'param_name'  => 'id',
					'value'       => $values,
					'save_always' => true,
					'admin_label' => true,
					'description' => __( 'Choose a previously created playlist from the drop down list.', 'audioigniter-pro' ),
				),
			),
		);
	}
}
