<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class Widget_AudioIgniter_Pro extends Widget_Base {
	public function get_name() {
		return 'ai-element';
	}

	public function get_title() {
		return __( 'AudioIgniter Element', 'audioigniter-pro' );
	}

	public function get_icon() {
		return 'eicon-headphones';
	}

	public function get_categories() {
		return [ 'audioigniter-pro' ];
	}

	public function is_reload_preview_required() {
		return true;
	}

	protected function register_controls() {
		$this->start_controls_section(
			'section_audioigniter',
			[
				'label' => __( 'AudioIgniter Element', 'audioigniter-pro' ),
			]
		);

		$this->add_control(
			'playlist',
			[
				'label'     => __( 'Playlist', 'audioigniter-pro' ),
				'type'      => Controls_Manager::SELECT,
				'default'   => '',
				'options'   => $this->get_playlists(),
				'separator' => 'after',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_style',
			[
				'label' => __( 'Player Appearance', 'audioigniter-pro' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);


		$this->add_control(
			'text_color',
			[
				'label'     => __( 'Text Color', 'audioigniter-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ai-wrap,
					{{WRAPPER}} .ai-wrap .ai-btn,
					{{WRAPPER}} .ai-wrap ai-track-btn' => 'color: {{VALUE}}',
					'{{WRAPPER}} .ai-wrap .ai-btn svg,
					{{WRAPPER}} .ai-wrap .ai-track-no-thumb svg,
					{{WRAPPER}} .ai-wrap .ai-track-btn svg' => 'fill: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'accent_color',
			[
				'label'     => __( 'Accent Color', 'audioigniter-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ai-wrap .ai-audio-control,
					{{WRAPPER}} .ai-wrap .ai-audio-control:hover,
					{{WRAPPER}} .ai-wrap .ai-audio-control:focus,
					{{WRAPPER}} .ai-wrap .ai-track-progress,
					{{WRAPPER}} .ai-wrap .ai-volume-bar.ai-volume-bar-active::before,
					{{WRAPPER}} .ai-wrap .ai-track:hover,
					{{WRAPPER}} .ai-wrap .ai-track.ai-track-active,
					{{WRAPPER}} .ai-wrap .ai-btn.ai-btn-active' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .ai-wrap .ai-scroll-wrap > div:last-child div' => 'background-color: {{VALUE}} !important',
					'{{WRAPPER}} .ai-wrap .ai-btn:hover,
					{{WRAPPER}} .ai-wrap .ai-btn:focus,
					{{WRAPPER}} .ai-wrap .ai-footer a,
					{{WRAPPER}} .ai-wrap .ai-footer a:hover' => 'color: {{VALUE}}',
					'{{WRAPPER}} .ai-wrap .ai-btn:hover svg,
					{{WRAPPER}} .ai-wrap .ai-btn:focus svg' => 'fill: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'text_on_accent',
			[
				'label'     => __( 'Text on Accent Color', 'audioigniter-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ai-wrap .ai-audio-control,
					{{WRAPPER}} .ai-wrap .ai-track:hover,
					{{WRAPPER}} .ai-wrap .ai-track.ai-track-active,
					{{WRAPPER}} .ai-wrap .ai-track.ai-track-active .ai-track-btn,
					{{WRAPPER}} .ai-wrap .ai-track:hover .ai-track-btn,
					{{WRAPPER}} .ai-wrap .ai-btn.ai-btn-active' => 'color: {{VALUE}}',
					'{{WRAPPER}} .ai-wrap .ai-audio-control svg,
					{{WRAPPER}} .ai-wrap .ai-track.ai-track-active .ai-track-btn svg,
					{{WRAPPER}} .ai-wrap .ai-track:hover .ai-track-btn svg,
					{{WRAPPER}} .ai-wrap .ai-btn.ai-btn-active svg' => 'fill: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'control_color',
			[
				'label'     => __( 'Control Color', 'audioigniter-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ai-wrap .ai-track-progress-bar,
					{{WRAPPER}} .ai-wrap .ai-volume-bar,
					{{WRAPPER}} .ai-wrap .ai-btn,
					{{WRAPPER}} .ai-wrap .ai-btn:hover,
					{{WRAPPER}} .ai-wrap .ai-btn:focus,
					{{WRAPPER}} .ai-wrap .ai-track,
					{{WRAPPER}} .ai-wrap .ai-track-no-thumb,
					{{WRAPPER}} .ai-wrap .ai-scroll-wrap > div:last-child' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .ai-wrap .ai-footer' => 'border-top-color: {{VALUE}}',
					'{{WRAPPER}} .ai-wrap.ai-is-loading .ai-control-wrap-thumb::after,
					{{WRAPPER}} .ai-wrap.ai-is-loading .ai-track-title::after,
					{{WRAPPER}} .ai-wrap.ai-is-loading .ai-track-subtitle::after' => 'background: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name'     => 'background',
				'label'    => __( 'Background', 'audioigniter-pro' ),
				'types'    => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .ai-wrap',
			]
		);

		//
		// Player Colors
		//

		$this->add_control(
			'player_text_color',
			[
				'label'     => __( 'Player Text', 'audioigniter-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ai-control-wrap' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'player_button_background_color',
			[
				'label'     => __( 'Player Button Background', 'audioigniter-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ai-control-wrap .ai-btn,
					 {{WRAPPER}} .ai-control-wrap .ai-btn:hover,
			     {{WRAPPER}} .ai-player-buttons .ai-btn,
			     {{WRAPPER}} .ai-player-buttons .ai-btn:hover,
					 {{WRAPPER}} .ai-wrap .ai-volume-bar' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'player_button_active_background_color',
			[
				'label'     => __( 'Player Active Background', 'audioigniter-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ai-control-wrap .ai-audio-control,
					 {{WRAPPER}} .ai-control-wrap .ai-audio-control:hover,
					 {{WRAPPER}} .ai-control-wrap .ai-audio-control:focus,
					 {{WRAPPER}} .ai-control-wrap .ai-btn.ai-btn-active,
					 {{WRAPPER}} .ai-wrap .ai-volume-bar.ai-volume-bar-active::before' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'player_button_text_color',
			[
				'label'     => __( 'Player Button Text', 'audioigniter-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ai-control-wrap .ai-btn,
					 {{WRAPPER}} .ai-control-wrap .ai-btn:hover,
			     {{WRAPPER}} .ai-player-buttons .ai-btn,
			     {{WRAPPER}} .ai-player-buttons .ai-btn:hover' => 'color: {{VALUE}}',
					'{{WRAPPER}} .ai-control-wrap .ai-btn svg,
					 {{WRAPPER}} .ai-control-wrap .ai-btn:hover svg' => 'fill: {{VALUE}}'
				],
			]
		);

		$this->add_control(
			'player_button_active_text_color',
			[
				'label'     => __( 'Player Text On Active', 'audioigniter-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ai-control-wrap .ai-btn.ai-btn-active' => 'color: {{VALUE}}',
					'{{WRAPPER}} .ai-control-wrap .ai-audio-control svg,
					 {{WRAPPER}} .ai-control-wrap .ai-btn.ai-btn-active svg' => 'fill: {{VALUE}}'
				],
			]
		);

		//
		// Track & Progress Bar Colors
		//

		$this->add_control(
			'track_bar_color',
			[
				'label'     => __( 'Track Bar', 'audioigniter-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ai-wrap .ai-track-progress-bar' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'progress_bar_color',
			[
				'label'     => __( 'Progress Bar', 'audioigniter-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ai-wrap .ai-track-progress' => 'background-color: {{VALUE}}',
				],
			]
		);

		//
		// Track & Playlist Colors
		//

		$this->add_control(
			'track_background_color',
			[
				'label'     => __( 'Track Background', 'audioigniter-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ai-wrap .ai-track' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'track_text_color',
			[
				'label'     => __( 'Track Text', 'audioigniter-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ai-wrap .ai-track,
					 {{WRAPPER}} .ai-wrap .ai-track-btn' => 'color: {{VALUE}}',
					'{{WRAPPER}} .ai-wrap .ai-track-btn svg' => 'fill: {{VALUE}}'
				],
			]
		);

		$this->add_control(
			'track_active_background_color',
			[
				'label'     => __( 'Active Track Background', 'audioigniter-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ai-wrap .ai-track:hover,
					 {{WRAPPER}} .ai-wrap .ai-track.ai-track-active' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'track_active_text_color',
			[
				'label'     => __( 'Active Track Text', 'audioigniter-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ai-wrap .ai-track:hover,
					 {{WRAPPER}} .ai-wrap .ai-track.ai-track-active' => 'color: {{VALUE}}',
					'{{WRAPPER}} .ai-wrap .ai-track:hover .ai-track-btn svg,
					{{WRAPPER}} .ai-wrap .ai-track.ai-track-active .ai-track-btn svg' => 'fill: {{VALUE}}'
				],
			]
		);

		$this->add_control(
			'track_button_background_color',
			[
				'label'     => __( 'Track Button Background', 'audioigniter-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ai-wrap .ai-track-btn' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'track_button_text_color',
			[
				'label'     => __( 'Track Button Text', 'audioigniter-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ai-wrap .ai-track-btn' => 'color: {{VALUE}}',
					'{{WRAPPER}} .ai-wrap .ai-track-btn svg,
					 {{WRAPPER}} .ai-wrap .ai-track:hover .ai-track-btn svg,
					 {{WRAPPER}} .ai-wrap .ai-track.ai-track-active .ai-track-btn svg' => 'fill: {{VALUE}}'
				],
			]
		);

		//
		// Lyrics Modal Colors
		//

		$this->add_control(
			'lyrics_modal_background_color',
			[
				'label'     => __( 'Lyrics Modal Background', 'audioigniter-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ai-modal' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'lyrics_modal_text_color',
			[
				'label'     => __( 'Lyrics Modal Text', 'audioigniter-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ai-modal,
					 {{WRAPPER}} .ai-modal-dismiss,
					 {{WRAPPER}} .ai-modal-dismiss:hover' => 'color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_section();
	}

	protected function get_playlists() {
		$args = array(
			'post_type'      => 'ai_playlist',
			'posts_per_page' => - 1,
		);

		$playlists = get_posts( $args );
		$options   = wp_list_pluck( $playlists, 'post_title', 'ID' );

		return $options;
	}

	protected function render() {
		$settings = $this->get_settings();
		$id       = $settings['playlist'];

		if ( ! $id ) {
			return;
		}

		?>
		<div
			id="ai-element-<?php echo esc_attr( $this->get_id() ); ?>"
			class="ai-element"
		>
			<?php echo do_shortcode( shortcode_unautop( '[ai_playlist id="' . $id . '"]' ) ); ?>
		</div>

			<script>
				jQuery(document).ready(function () {
					jQuery(document).trigger('elementor/render/ai-element', '#ai-element-<?php echo esc_attr( $this->get_id() ); ?>');
				});
			</script>
		<?php
	}

	protected function content_template() {}
}

add_action( 'elementor/widgets/widgets_registered', function ( $widgets_manager ) {
	$widgets_manager->register_widget_type( new Widget_AudioIgniter_Pro() );
} );
