"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getQueryArg = getQueryArg;
var _getQueryArgs = require("./get-query-args");
/**
 * Internal dependencies
 */

/**
 * @typedef {{[key: string]: QueryArgParsed}} QueryArgObject
 */

/**
 * @typedef {string|string[]|QueryArgObject} QueryArgParsed
 */

/**
 * Returns a single query argument of the url
 *
 * @param {string} url URL.
 * @param {string} arg Query arg name.
 *
 * @example
 * ```js
 * const foo = getQueryArg( 'https://wordpress.org?foo=bar&bar=baz', 'foo' ); // bar
 * ```
 *
 * @return {QueryArgParsed|void} Query arg value.
 */
function getQueryArg(url, arg) {
  return (0, _getQueryArgs.getQueryArgs)(url)[arg];
}
//# sourceMappingURL=get-query-arg.js.map