<?php
/**
 * Class Crisp
 *
 * @package Crisp
 */
namespace Crisp;

require_once dirname( __FILE__ ) . '/CrispWidget.class.php';

use Crisp\CrispWidget;

class Crisp {
	/**
	 * Singleton pattern
	 *
	 * @var Crisp $instance
	 */
	protected static $instance;
	
	/**
	 * Starts the plugin
	 */
	public function __construct() {
		$this->init();
	}
	
	/**
	 * Returns instance of Crisp class (singleton pattern).
	 *
	 * @return Crisp
	 */
	public static function get_instance() {
		if ( !isset( static::$instance ) ) {
			static::$instance = new static();
		}

		return static::$instance;
	}

	public function init() {
		CrispWidget::get_instance();
	}
}
