<?php
/**
 * Class CrispAdmin
 *
 * @package Crisp
 */
namespace Crisp;

require_once dirname( __FILE__ ) . '/Crisp.class.php';
require_once dirname( __FILE__ ) . '/CrispSettings.class.php';

use Crisp\CrispSettings;

class CrispAdmin extends Crisp {
	/**
	 * Returns instance of Crisp class (singleton pattern).
	 *
	 * @return Crisp
	 */
	public static function get_instance() {
		if ( !isset( static::$instance ) ) {
			static::$instance = new static();
		}

		return static::$instance;
	}

	public function init() {
		CrispSettings::get_instance();
	}
}
