<?php
/**
 * Plugin Name: Crisp for Woocommerce 
 * Description: A multichannel helpdesk software that integrates with WooCommerce
 * Plugin URI: http://wordpress.org/plugins/crisp/
 * Author: Crisp IM
 * Version: 0.4
 * Author URI: https://crisp.chat
 * Text Domain: crisp-woocommerce
*/

define('WP_CRISP_WOOCOMMERCE', true);
define('CRISP_PLUGIN_URL', 'https://plugins.crisp.chat/urn:crisp.im:woocommerce:0');
define('CRISP_PLUGIN_ID', '807fead9-21ad-456a-86c3-6ea7d8f2edb1');

if (is_admin()) {
	require_once dirname( __FILE__ ) . '/components/CrispAdmin.class.php';
	\Crisp\CrispAdmin::get_instance();

	register_deactivation_hook( __FILE__ , function() {
		delete_option( 'website_id' );
		delete_option( 'crisp_onboarding' );
		delete_option( 'website_verify' );
	});
} else {
	require_once dirname( __FILE__ ) . '/components/Crisp.class.php';
	\Crisp\Crisp::get_instance();
}
