<?php
namespace Embedpress\Pro\Classes;

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Handles license input and validation
 */
class EmbedPress_Licensing {
	private $product_slug;
	private $text_domain;
	private $product_name;
	private $license_manager;
	private $item_id;

	/**
	 * Initializes the license manager client.
	 * @param $product_slug
	 * @param $product_name
	 * @param $text_domain
	 */
	public function __construct( $product_slug, $product_name, $text_domain, $license_manager ) {
		// Store setup data
		$this->product_slug    = $product_slug;
		$this->product_name    = $product_name;
		$this->license_manager = $license_manager;
		$this->item_id         = EMBEDPRESS_SL_ITEM_ID;

		// Init
		$this->add_actions();
	}
	/**
	 * Adds actions required for class functionality
	 */
	public function add_actions() {
		if ( is_admin() ) {
			// Add the menu screen for inserting license information
			//add_action( 'admin_init', array( $this, 'register_license_settings' ) );
			// TODO: remove this action after testing
			// add_action( 'admin_notices', array( $this, 'admin_notices' ) );
			add_action( 'embedpress_license_tab', array( $this, 'render_licenses_tab' ) );
			add_action( 'embedpress_license', array( $this, 'render_licenses_page' ) );

		}
	}

	/**
	 * @return string   The slug id of the licenses settings page.
	 */
	protected function get_settings_page_slug() {
		return 'embedpress&page_type=license';
	}

	/**
	 * Creates the settings fields needed for the license settings menu.
	 */
	public function register_license_settings() {
		// creates our settings in the options table
		register_setting( $this->get_settings_page_slug(), $this->product_slug . '-license-key', 'sanitize_license' );
	}

	public function sanitize_license( $new ) {
		$old = get_option( $this->product_slug . '-license-key' );
		if ( $old && $old != $new ) {
			delete_option( $this->product_slug . '-license-status' ); // new license has been entered, so must reactivate
		}
		return $new;
	}

	/**
	 * Handles admin notices for errors and license activation
	 *
	 * @since 0.1.0
	 */

	public function admin_notices() {
		$status = $this->get_license_status();
		$license_data = $this->get_license_data();

		if( isset( $license_data->license ) ) {
			$status = $license_data->license;
		}

		if( $status === 'http_error' ) {
			return;
		}

		if ( ( $status === false || $status !== 'valid' ) && $status !== 'expired' ) {
			$msg = __( 'Please %1$sactivate your license%2$s key to enable updates for %3$s.', 'embedpress-pro' );
			$msg = sprintf( $msg, '<a href="' . admin_url( 'admin.php?page=' . $this->get_settings_page_slug() ) . '">', '</a>',	'<strong>' . esc_html($this->product_name) . '</strong>' );
			?>
            <div class="notice notice-error">
                <p><?php echo wp_kses_post($msg); ?></p>
            </div>
			<?php
		}
		if ( $status === 'expired' ) {
			$msg = __( 'Your license has been expired. Please %1$srenew your license%2$s key to enable updates for %3$s.',	'embedpress-pro' );
			$msg = sprintf( $msg, '<a href="https://store.wpdeveloper.com">', '</a>', '<strong>' . $this->product_name . '</strong>' );
			?>
            <div class="notice notice-error">
                <p><?php echo wp_kses_post($msg); ?></p>
            </div>
			<?php
		}
		if ( ( isset( $_GET['sl_activation'] ) || isset( $_GET['sl_deactivation'] ) ) && ! empty( $_GET['message'] ) ) {
			$target = isset( $_GET['sl_activation'] ) ? $_GET['sl_activation'] : null;
			$target = is_null( $target ) ? ( isset( $_GET['sl_deactivation'] ) ? $_GET['sl_deactivation'] : null ) : null;
			switch( $target ) {
				case 'false':
					$message = urldecode( $_GET['message'] );
					?>
                    <div class="error">
                        <p><?php echo wp_kses_post($message); ?></p>
                    </div>
					<?php
					break;
				case 'true':
				default:
					// Developers can put a custom success message here for when activation is successful if they way.
					break;

			}
		}
	}

	/**
	 * Renders the settings page for entering license information.
	 */
	public function render_licenses_page() {
		$license_data 	= $this->license_manager->get_license_data();
		$license_key 	= $this->license_manager->hide_license_key(isset($license_data['license_key']) ? $license_data['license_key'] : '');
		$status 		= isset($license_data['license_status']) ? $license_data['license_status'] : '';
		//$status 		= 'valid';
		//$status = false; // @TODO; remove after testing
		?>

        <div class="embedpress-license__details radius-25 o-hidden">
            <div class="license__content">


	            <?php if( $status == false && $status !== 'valid' ) { ?>
                    <div class="thumb__area">
                        <img src="<?php echo EMBEDPRESS_SETTINGS_ASSETS_URL; ?>img/unlock-license.svg" alt="">
                        <h2><?php esc_html_e( "Just one more step to go!", "embedpress-pro" ); ?></h2>
                    </div>
                    <p><?php esc_html_e( "Enter your license key here, to activate EmbedPress Pro, and get automatic updates and premium support.", "embedpress-pro" ); ?> <?php
			            /** Translator: % : https://embedpress.com/docs/embedpress-pro-license/ */
			            printf( __( 'Visit the <a href="%s" target="_blank">Validation Guide</a> for help.', 'embedpress-pro' ), 'https://embedpress.com/docs/embedpress-pro-license/' ); ?>
                    </p>
                    <ol>
                        <li><?php printf( __( 'Log in to <a href="%s" target="_blank">your account</a> to get your license key.', 'embedpress-pro' ), 'https://store.wpdeveloper.com/' ); ?></li>
                        <li><?php printf( __( 'If you don\'t yet have a license key, get <a href="%s" target="_blank">EmbedPress Pro now</a>.', 'embedpress-pro' ), 'https://embedpress.com/#pricing' ); ?></li>
                        <li><?php _e( __( 'Copy the license key from your account and paste it below.', 'embedpress-pro' ) ); ?></li>
                        <li><?php _e( __( 'Click on <strong>"Activate License"</strong> button.', 'embedpress-pro' ) ); ?></li>
                    </ol>
	            <?php } ?>


	            <?php if( $status !== false && $status == 'valid' ) { ?>
                    <div class="validated-feature-list">
                        <div class="validated-feature-list-item">
                            <div class="validated-feature-list-icon">
                                <img src="<?php echo EMBEDPRESS_PRO_PLUGIN_URL . 'assets/admin/images/icon-auto-update.svg'; ?>" alt="embedpress-auto-update">
                            </div>
                            <div class="validated-feature-list-content">
                                <h4><?php _e( 'Auto Update','embedpress-pro' );?></h4>
                                <p>
						            <?php _e( 'Update the plugin right from your WordPress Dashboard.','embedpress-pro' );?>
                                </p>
                            </div>
                        </div><!--./feature-list-item-->
                        <div class="validated-feature-list-item">
                            <div class="validated-feature-list-icon">
                                <img src="<?php echo EMBEDPRESS_PRO_PLUGIN_URL . 'assets/admin/images/premium-support.svg'; ?>" alt="embedpress-auto-update">
                            </div>
                            <div class="validated-feature-list-content">
                                <h4><?php _e('Premium Support', 'embedpress-pro'); ?></h4>
                                <p><?php _e('Supported by professional and courteous staff.', 'embedpress-pro'); ?></p>
                            </div>
                        </div><!--./feature-list-item-->
                    </div><!--./feature-list-->
	            <?php } ?>

                <form action="" method="post"  class="form__inline">
					<div class="form-inner-field">
						<?php
						do_action( 'embedpress_before_license_settings_fields');
						?>
						<div class="form__group">
							<?php if( $status == false && $status !== 'valid' ) { ?>
								<span class="input__icon"><i class="ep-icon ep-lock"></i></span>
							<?php } ?>
							<?php if( $status !== false && $status == 'valid' ) { ?>
								<img class="input__icon" src="<?php echo EMBEDPRESS_PRO_PLUGIN_URL . 'assets/admin/images/icon-license-valid.svg'; ?>" alt="embedpress-licnese">
							<?php } ?>
							<input <?php echo ( $status !== false && $status == 'valid' ) ? 'disabled' : ''; ?> id="<?php echo esc_attr($this->product_slug); ?>-license-key" name="<?php echo esc_attr($this->product_slug); ?>-license-key" type="text" class="form__control" value="<?php echo esc_attr( $license_key ); ?>" placeholder=" <?php esc_attr_e( 'Place Your License Key and Activate','embedpress-pro' );?>" required />
						</div>


						<?php do_action( 'embedpress_after_license_settings_fields'); ?>

						<!--License Button STARTS-->
						<?php
						wp_nonce_field( $this->product_slug . '_license_nonce', $this->product_slug . '_license_nonce' );
						if( $status !== false && $status == 'valid' ) { ?>
							<input type="hidden" name="action" value="eae_pro_deactivate_license"/>
							<input type="hidden" name="<?php echo esc_attr($this->product_slug); ?>_license_deactivate" />
							<button class="button radius-10 embedpress-license-deactivation-btn" name="submit" value="deactivate_license"><?php esc_html_e( 'Deactivate License', 'embedpress-pro'); ?></button>
						<?php } else { ?>
							<input type="hidden" name="<?php echo esc_attr($this->product_slug); ?>_license_activate" />
							<button class="button button__themeColor radius-10 embedpress-license-activation-btn" name="submit" value="activate_license"><?php esc_html_e( 'Activate License', 'embedpress-pro'); ?></button>
						<?php }
						?>
						<!--License Button ENDS-->

					</div>

					<div id="valid-license-key-message" class="hidden"><?php echo sprintf(__('License Verification code has been sent to %s. Please check email for code and insert below 👇', 'embedpress'), '<span id="email-placeholder">{email}</span>'); ?></div>
					

                </form>

	
				<form action="" method="post" class="form__inline hidden" id="otp-varify-form">
					<div class="form-inner-field">
						<?php
						do_action('embedpress_before_verification_settings_fields');
						?>
						<div class="form__group">
							<input <?php echo ($status !== false && $status == 'valid') ? 'disabled' : ''; ?> id="<?php echo esc_attr($this->product_slug); ?>-verification-key" name="<?php echo esc_attr($this->product_slug); ?>-verification-code" type="text" class="form__control" value="<?php echo esc_attr($license_key); ?>" placeholder=" <?php esc_attr_e('Enter Your Verification Code', 'embedpress-pro'); ?>" required />
						</div>

						<?php do_action('embedpress_after_verification_settings_fields'); ?>

						<!--verification Button STARTS-->
						<?php
						wp_nonce_field($this->product_slug . '_verification_nonce', $this->product_slug . '_verification_nonce');
						if ($status !== false && $status == 'valid') { ?>
							<input type="hidden" name="action" value="eae_pro_deactivate_verification" />
							<input type="hidden" name="<?php echo esc_attr($this->product_slug); ?>_verification_deactivate" />
							<button class="button radius-10 embedpress-verification-deactivation-btn" name="submit" value="deactivate_verification"><?php esc_html_e('Deactivate verification', 'embedpress-pro'); ?></button>
						<?php } else { ?>
							<input type="hidden" name="<?php echo esc_attr($this->product_slug); ?>_verification_activate" />
							<button class="button button__themeColor radius-10 embedpress-verification-activation-btn" name="submit" value="activate_verification"><?php esc_html_e('Verify', 'embedpress-pro'); ?></button>
						<?php }
						?>
						<!--verification Button ENDS-->
					</div>

					<div id="resend-verification-key-message">
						<?php echo esc_html__('Haven’t received any email ? Retry clicking on ', 'embedpress'); ?> 
						<span id="resend-license-verification-key"><?php echo esc_html__('Resend', 'embedpress'); ?></span>
						<?php echo esc_html__('button. Please note that, this code will expire after 15 minutes. Facing any issues? Follow this', 'embedpress'); ?> <a target="_blank" href="<?php echo esc_url('https://embedpress.com/docs/embedpress-pro-license/'); ?>"><?php echo esc_html__('Guide', 'embedpress'); ?></a> <?php echo esc_html__('or contact ', 'embedpress'); ?><a target="_blank" href="<?php echo esc_url('https://wpdeveloper.com/support'); ?>"><?php echo esc_html__('Support', 'embedpress'); ?></a>.
					</div>

					<div id="invalid-verification-key-message" class="hidden"><?php echo sprintf( __( 'Invalid Verification Code', 'embedpress' ) );?></div>
				</form>

            </div>
            <div class="license__manage">
                <img src="<?php echo EMBEDPRESS_SETTINGS_ASSETS_URL; ?>img/logo.svg" alt="">
                <a href="https://store.wpdeveloper.com/" target="_blank" class="button radius-10"><?php esc_html_e( "Manage License", "embedpress-pro" ); ?></a>
            </div>
	        <?php
           $this->show_notification();
            ?>
        </div>
		<?php
	}

	public function render_licenses_tab($activeTab){
        ?>
            <a href="?page=embedpress&tab=embedpress_license"
               class="nav-tab<?php echo ($activeTab === 'embedpress_license' || empty( $activeTab )) ? ' nav-tab-active' : ''; ?> ">
                <?php esc_html_e( 'License', 'embedpress-pro'); ?>
            </a>
        <?php
    }

	public function show_notification() {

		if ( !empty( $_GET['message']) ) {
			$success_message = $error_message = $_GET['message'];
		}else{
			$success_message = "License updated"; // already translated by free version
			$error_message = "Ops! Something went wrong."; // already translated by free version
		}
        ?>

        <div class="embedpress-toast__message toast__message--success">
            <img src="<?php echo EMBEDPRESS_SETTINGS_ASSETS_URL; ?>img/check.svg" alt="">
            <p><?php echo esc_html( $success_message); ?></p>
        </div>

        <div class="embedpress-toast__message toast__message--error">
            <img src="<?php echo EMBEDPRESS_SETTINGS_ASSETS_URL; ?>img/error.svg" alt="">
            <p><?php echo esc_html( $error_message); ?></p>
        </div>

        <?php  if (!empty( $_GET['success'])){ ?>
        <script>
            (function ($) {
                let $success_message_node = $('.toast__message--success');
                $success_message_node.addClass('show');
                setTimeout(function (){
                    $success_message_node.removeClass('show');
                    let cleanUrl = embedPressRemoveURLParameter(location.href, 'success');
                        cleanUrl = embedPressRemoveURLParameter(cleanUrl, 'message');
                        cleanUrl = embedPressRemoveURLParameter(cleanUrl, 'sl_activation');
                    history.pushState('', '', cleanUrl );
                }, 5000);

            })(jQuery);
        </script>
        <?php  } elseif (!empty( $_GET['error'])){ ?>
                <script>
                    (function ($) {
                        let $error_message_node = $('.toast__message--error');
                        $error_message_node.addClass('show');
                        setTimeout(function (){
                            $error_message_node.removeClass('show');
                            let cleanUrl = embedPressRemoveURLParameter(location.href, 'sl_activation');
                            cleanUrl = embedPressRemoveURLParameter(cleanUrl, 'message');
                            cleanUrl = embedPressRemoveURLParameter(cleanUrl, 'sl_deactivation');
                            history.pushState('', '', cleanUrl );
                        }, 5000);

                    })(jQuery);
                </script>
                <?php
            }
	}
}
