<?php

/**
 * Note : Code is released under the GNU LGPL
 *
 * Please do not change the header of this file
 *
 * This library is free software; you can redistribute it and/or modify it under the terms of the GNU
 * Lesser General Public License as published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See the GNU Lesser General Public License for more details.
 */
/**
 * File:        PieceType.php
 * Project:     DHL API
 *
 * @author      Al-Fallouji Bashar
 * @version     0.1
 */
namespace DhlVendor\DHL\Datatype\AM;

use DhlVendor\DHL\Datatype\Base;
/**
 * PieceType Request model for DHL API
 */
class PieceType extends \DhlVendor\DHL\Datatype\Base
{
    /**
     * Is this object a subobject
     * @var boolean
     */
    protected $_isSubobject = \true;
    /**
     * Parent node name of the object 
     * @var string
     */
    protected $_xmlNodeName = 'Piece';
    /**
     * Parameters of the datatype
     * @var array
     */
    protected $_params = array('PieceID' => array('type' => '', 'required' => \true, 'subobject' => \false), 'PackageTypeCode' => array('type' => '', 'required' => \false, 'subobject' => \false), 'Height' => array('type' => '', 'required' => \false, 'subobject' => \false), 'Depth' => array('type' => '', 'required' => \false, 'subobject' => \false), 'Width' => array('type' => '', 'required' => \false, 'subobject' => \false), 'Weight' => array('type' => '', 'required' => \true, 'subobject' => \false));
}
