<?php

/**
 * Note : Code is released under the GNU LGPL
 *
 * Please do not change the header of this file
 *
 * This library is free software; you can redistribute it and/or modify it under the terms of the GNU
 * Lesser General Public License as published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See the GNU Lesser General Public License for more details.
 */
/**
 * File:        ExportDeclaration.php
 * Project:     DHL API
 *
 * @author      Al-Fallouji Bashar
 * @version     0.1
 */
namespace DhlVendor\DHL\Datatype\GB;

use DhlVendor\DHL\Datatype\Base;
/**
 * ExportDeclaration Request model for DHL API
 */
class ExportDeclaration extends \DhlVendor\DHL\Datatype\Base
{
    /**
     * Is this object a subobject
     * @var boolean
     */
    protected $_isSubobject = \true;
    /**
     * Parameters of the datatype
     * @var array
     */
    protected $_params = array('InterConsignee' => array('type' => '', 'required' => \false, 'subobject' => \false), 'IsPartiesRelation' => array('type' => 'YesNo', 'required' => \false, 'subobject' => \false, 'comment' => 'Boolean flag', 'length' => '1', 'enumeration' => 'Y,N'), 'ECCN' => array('type' => '', 'required' => \false, 'subobject' => \false), 'SignatureName' => array('type' => 'SignatureName', 'required' => \false, 'subobject' => \false, 'comment' => 'Signature name', 'maxLength' => '35'), 'SignatureTitle' => array('type' => 'SignatureTitle', 'required' => \false, 'subobject' => \false, 'comment' => 'Signature title', 'maxLength' => '35'), 'ExportReason' => array('type' => 'ExportReason', 'required' => \false, 'subobject' => \false, 'comment' => 'Export reason', 'length' => '1'), 'ExportReasonCode' => array('type' => 'ExportReasonCode', 'required' => \false, 'subobject' => \false, 'comment' => 'Export reason code (P:Permanent, T:Temporary, R:Re-Export)', 'length' => '1', 'enumeration' => 'P,T,R'), 'SedNumber' => array('type' => 'SEDNumber', 'required' => \false, 'subobject' => \false, 'comment' => '', 'enumeration' => 'FTSR,XTN,SAS,ITN'), 'SedNumberType' => array('type' => 'SEDNumberType', 'required' => \false, 'subobject' => \false, 'comment' => '', 'length' => '1', 'enumeration' => 'F,X,S,I'), 'MxStateCode' => array('type' => '', 'required' => \false, 'subobject' => \false), 'ExportLineItems' => array('type' => 'ExportLineItem', 'required' => \false, 'subobject' => \true, 'multivalues' => \true, 'disableParentNode' => \true));
}
