<?php

/**
 * Note : Code is released under the GNU LGPL
 *
 * Please do not change the header of this file
 *
 * This library is free software; you can redistribute it and/or modify it under the terms of the GNU
 * Lesser General Public License as published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See the GNU Lesser General Public License for more details.
 */
/**
 * File:        DCTRequest.php
 * Project:     DHL API
 *
 * @author      Al-Fallouji Bashar
 * @version     0.1
 */
namespace DhlVendor\DHL\Entity\AM;

use DhlVendor\DHL\Entity\Base;
/**
 * DCTRequest Request model for DHL API
 */
class DCTRequest extends \DhlVendor\DHL\Entity\Base
{
    /**
     * Is this object a subobject
     * @var boolean
     */
    protected $_isSubobject = \false;
    /**
     * Name of the service
     * @var string
     */
    protected $_serviceName = 'DCTRequest';
    /**
     * @var string
     * Service XSD
     */
    protected $_serviceXSD = 'DCT-req.xsd';
    /**
     * Parameters to be send in the body
     * @var array
     */
    protected $_bodyParams = array('GetCapability' => array('type' => 'GetCapability', 'required' => \false, 'subobject' => \true, 'multivalues' => \false, 'minOccurs' => 0));
}
