<?php

/**
 * Note : Code is released under the GNU LGPL
 *
 * Please do not change the header of this file
 *
 * This library is free software; you can redistribute it and/or modify it under the terms of the GNU
 * Lesser General Public License as published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See the GNU Lesser General Public License for more details.
 */
/**
 * File:        UnknownTrackingRequest.php
 * Project:     DHL API
 *
 * @author      Al-Fallouji Bashar
 * @version     0.1
 */
namespace DhlVendor\DHL\Entity\EA;

use DhlVendor\DHL\Entity\Base;
/**
 * UnknownTrackingRequest Request model for DHL API
 */
class UnknownTrackingRequest extends \DhlVendor\DHL\Entity\Base
{
    /**
     * Is this object a subobject
     * @var boolean
     */
    protected $_isSubobject = \false;
    /**
     * Name of the service
     * @var string
     */
    protected $_serviceName = 'UnknownTrackingRequest';
    /**
     * @var string
     * Service XSD
     */
    protected $_serviceXSD = 'UnknownTrackingRequest.xsd';
    /**
     * Parameters to be send in the body
     * @var array
     */
    protected $_bodyParams = array('LanguageCode' => array('type' => 'string', 'required' => \false, 'subobject' => \false, 'comment' => 'ISO Language Code'), 'AccountNumber' => array('type' => 'string', 'required' => \true, 'subobject' => \false, 'comment' => 'DHL Account Number', 'maxInclusive' => '9999999999', 'minInclusive' => '100000000'), 'ShipperReference' => array('type' => 'string', 'required' => \false, 'subobject' => \false), 'ShipmentDate' => array('type' => 'ShipmentDate', 'required' => \false, 'subobject' => \true), 'CountryCode' => array('type' => 'string', 'required' => \false, 'subobject' => \false, 'comment' => 'ISO country codes', 'length' => '2'));
}
