<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/ads/googleads/v20/common/bidding.proto

namespace Google\Ads\GoogleAds\V20\Common;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * An automated bidding strategy to help get the most conversion value for your
 * campaigns while spending your budget.
 *
 * Generated from protobuf message <code>google.ads.googleads.v20.common.MaximizeConversionValue</code>
 */
class MaximizeConversionValue extends \Google\Protobuf\Internal\Message
{
    /**
     * The target return on ad spend (ROAS) option. If set, the bid strategy will
     * maximize revenue while averaging the target return on ad spend. If the
     * target ROAS is high, the bid strategy may not be able to spend the full
     * budget. If the target ROAS is not set, the bid strategy will aim to
     * achieve the highest possible ROAS for the budget.
     *
     * Generated from protobuf field <code>double target_roas = 2;</code>
     */
    protected $target_roas = 0.0;
    /**
     * Maximum bid limit that can be set by the bid strategy.
     * The limit applies to all keywords managed by the strategy.
     * Mutable for portfolio bidding strategies only.
     *
     * Generated from protobuf field <code>int64 cpc_bid_ceiling_micros = 3;</code>
     */
    protected $cpc_bid_ceiling_micros = 0;
    /**
     * Minimum bid limit that can be set by the bid strategy.
     * The limit applies to all keywords managed by the strategy.
     * Mutable for portfolio bidding strategies only.
     *
     * Generated from protobuf field <code>int64 cpc_bid_floor_micros = 4;</code>
     */
    protected $cpc_bid_floor_micros = 0;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type float $target_roas
     *           The target return on ad spend (ROAS) option. If set, the bid strategy will
     *           maximize revenue while averaging the target return on ad spend. If the
     *           target ROAS is high, the bid strategy may not be able to spend the full
     *           budget. If the target ROAS is not set, the bid strategy will aim to
     *           achieve the highest possible ROAS for the budget.
     *     @type int|string $cpc_bid_ceiling_micros
     *           Maximum bid limit that can be set by the bid strategy.
     *           The limit applies to all keywords managed by the strategy.
     *           Mutable for portfolio bidding strategies only.
     *     @type int|string $cpc_bid_floor_micros
     *           Minimum bid limit that can be set by the bid strategy.
     *           The limit applies to all keywords managed by the strategy.
     *           Mutable for portfolio bidding strategies only.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Ads\GoogleAds\V20\Common\Bidding::initOnce();
        parent::__construct($data);
    }

    /**
     * The target return on ad spend (ROAS) option. If set, the bid strategy will
     * maximize revenue while averaging the target return on ad spend. If the
     * target ROAS is high, the bid strategy may not be able to spend the full
     * budget. If the target ROAS is not set, the bid strategy will aim to
     * achieve the highest possible ROAS for the budget.
     *
     * Generated from protobuf field <code>double target_roas = 2;</code>
     * @return float
     */
    public function getTargetRoas()
    {
        return $this->target_roas;
    }

    /**
     * The target return on ad spend (ROAS) option. If set, the bid strategy will
     * maximize revenue while averaging the target return on ad spend. If the
     * target ROAS is high, the bid strategy may not be able to spend the full
     * budget. If the target ROAS is not set, the bid strategy will aim to
     * achieve the highest possible ROAS for the budget.
     *
     * Generated from protobuf field <code>double target_roas = 2;</code>
     * @param float $var
     * @return $this
     */
    public function setTargetRoas($var)
    {
        GPBUtil::checkDouble($var);
        $this->target_roas = $var;

        return $this;
    }

    /**
     * Maximum bid limit that can be set by the bid strategy.
     * The limit applies to all keywords managed by the strategy.
     * Mutable for portfolio bidding strategies only.
     *
     * Generated from protobuf field <code>int64 cpc_bid_ceiling_micros = 3;</code>
     * @return int|string
     */
    public function getCpcBidCeilingMicros()
    {
        return $this->cpc_bid_ceiling_micros;
    }

    /**
     * Maximum bid limit that can be set by the bid strategy.
     * The limit applies to all keywords managed by the strategy.
     * Mutable for portfolio bidding strategies only.
     *
     * Generated from protobuf field <code>int64 cpc_bid_ceiling_micros = 3;</code>
     * @param int|string $var
     * @return $this
     */
    public function setCpcBidCeilingMicros($var)
    {
        GPBUtil::checkInt64($var);
        $this->cpc_bid_ceiling_micros = $var;

        return $this;
    }

    /**
     * Minimum bid limit that can be set by the bid strategy.
     * The limit applies to all keywords managed by the strategy.
     * Mutable for portfolio bidding strategies only.
     *
     * Generated from protobuf field <code>int64 cpc_bid_floor_micros = 4;</code>
     * @return int|string
     */
    public function getCpcBidFloorMicros()
    {
        return $this->cpc_bid_floor_micros;
    }

    /**
     * Minimum bid limit that can be set by the bid strategy.
     * The limit applies to all keywords managed by the strategy.
     * Mutable for portfolio bidding strategies only.
     *
     * Generated from protobuf field <code>int64 cpc_bid_floor_micros = 4;</code>
     * @param int|string $var
     * @return $this
     */
    public function setCpcBidFloorMicros($var)
    {
        GPBUtil::checkInt64($var);
        $this->cpc_bid_floor_micros = $var;

        return $this;
    }

}

