export default class SpeechManager{constructor(t,e){this.recognition=null,this.isPressAndHold=!1,this.pressTimer=null,this.holdThreshold=500,this.recognizing=!1,this.transcript="",this.userEndedRecognition=!1,this.MTai=t,this.browser=e,this.mouseOverMic=!1,this.init()}supportSpeech(){return window.isSecureContext?"SpeechRecognition"in window||"webkitSpeechRecognition"in window:(this.MTai.updateStatus("Speech recognition requires HTTPS. Please use a secure connection.","error"),!1)}init(){if(this.supportSpeech()){const t=TvrMT.data.dyn.ui_config.locale||"en-US";this.recognition=new(window.SpeechRecognition||window.webkitSpeechRecognition),this.recognition.lang=t,this.recognition.continuous=!0,this.recognition.interimResults=!1,this.recognition.maxAlternatives=5,this.handleMicButton("tvr-ai-mic"),this.recognition.onstart=()=>{this.recognizing=!0,this.lastError?this.MTai.updateStatus(this.lastError,"error"):this.MTai.updateStatus("Setting up...")},this.recognition.onend=()=>{this.recognizing=!1,this.MTai.updateStatus("Listener disconnected."),document.getElementById("ai-assistant-panel").classList.remove("mic-receiving"),this.userEndedRecognition||setTimeout((()=>this.startListening()),500)},this.recognition.onresult=this.handleResult.bind(this),this.recognition.onerror=this.handleError.bind(this),window.addEventListener("beforeunload",(()=>this.stopListening()));const e=document.getElementById("tvr-ai-prompt");e.addEventListener("input",(()=>{this.transcript=e.value}))}}async handleResult(t){this.lastError="";for(let e=t.resultIndex;e<t.results.length;e++){const i=t.results[e];i.isFinal&&(this.transcript=this.transcript.trim(),this.transcript+=(this.transcript?" ":"")+i[0].transcript.trim())}const e=document.getElementById("tvr-ai-prompt");document.getElementById("ai-assistant-panel").classList.remove("mic-receiving"),this.transcript&&(/send prompt/i.test(this.transcript)?(this.transcript=this.transcript.replace(/send prompt/i,"").trim(),e.value=this.transcript,await this.MTai.sendPrompt(null,{requestContext:this.MTai.requestContext},!1,this)):e.value=this.transcript)}handleError(t){this.lastError=this.getErrorMessage(t.error),"not-allowed"===t.error?this.showBrowserInstructions():this.MTai.updateStatus(this.lastError,"error")}getErrorMessage(t){switch(t){case"no-speech":return"No speech detected. Please speak more clearly or check your microphone settings.";case"audio-capture":return"No microphone detected. Please connect a microphone and refresh the page.";case"not-allowed":return"Microphone access denied. See instructions below for enabling access.";case"network":return"Network error occurred. Check your internet connection. If using 'Edge', try switching to Chrome.";case"aborted":return"Speech recognition was aborted. Please try again.";default:return`Speech recognition error: ${t}. Please try refreshing the page.`}}async startListening(){this.recognition&&!this.isRecognitionActive()&&(this.recognition.start(),this.recognizing=!0,this.lastError="",this.testMicrophoneVolume(),document.getElementById("ai-assistant-panel").classList.add("mic-active"))}stopListening(){this.isRecognitionActive()&&(this.recognition.stop(),this.recognizing=!1,document.getElementById("ai-assistant-panel").classList.remove("mic-active"),this.currentAudioStream&&(this.currentAudioStream.getTracks().forEach((t=>t.stop())),this.currentAudioStream=null))}isRecognitionActive(){return this.recognition&&this.recognizing}handleMicButton(t){const e=document.getElementById(t);let i=0;e.addEventListener("mouseenter",(()=>{this.mouseOverMic=!0,document.getElementById("ai-assistant-panel").classList.add("mic-hover")})),e.addEventListener("mouseleave",(()=>{this.mouseOverMic=!1,document.getElementById("ai-assistant-panel").classList.remove("mic-hover")}));const s=async()=>!!await this.alertIssues()&&(this.userEndedRecognition=!1,this.startListening(),!0),n=()=>{this.userEndedRecognition=!0,this.stopListening()};e.addEventListener("mousedown",(()=>{i=Date.now(),this.pressTimer=setTimeout((async()=>{await s()&&(this.isPressAndHold=!0)}),this.holdThreshold)})),document.addEventListener("mouseup",(t=>{if(clearTimeout(this.pressTimer),this.isPressAndHold){const t=Date.now()-i;clearTimeout(this.pressTimer),t>=this.holdThreshold&&(this.transcript.trim()&&this.MTai.sendPrompt(null,{requestContext:this.MTai.requestContext}),n(),this.isPressAndHold=!1,this.mouseOverMic&&(this.abortNextClick=!0))}})),e.addEventListener("click",(async t=>{if(this.isPressAndHold||this.abortNextClick)return t.preventDefault(),void(this.abortNextClick=!1);this.isRecognitionActive()?n():await s()}))}async alertIssues(){const t=await this.listAudioDevices();if(0===t.length)return this.MTai.updateStatus("No microphones detected. Please connect a microphone and refresh the page.","error"),!1;return await this.checkMicrophoneAccess()?t[0]:(this.showBrowserInstructions(),!1)}async listAudioDevices(){const t=(await navigator.mediaDevices.enumerateDevices()).filter((t=>"audioinput"===t.kind));return t.forEach(((t,e)=>{})),t}async checkMicrophoneAccess(){try{return(await navigator.mediaDevices.getUserMedia({audio:!0})).getTracks().forEach((t=>t.stop())),!0}catch(t){return console.error("Microphone access denied:",t.message),!1}}showBrowserInstructions(){const t=this.browser;let e="";if(!window.isSecureContext)return e="\n\t\t\t\t<p><strong>Warning:</strong> Speech recognition requires a secure HTTPS connection.</p>\n\t\t\t\t<p>Please access this site using HTTPS with a valid SSL certificate.</p>",void this.MTai.updateStatus(e,"error");switch(t){case"Chrome":e='<p><strong>To enable the microphone in Chrome</strong>:</p>\n\t\t\t\t<ol>\n\t\t\t\t\t<li>Click the icon at the top left of the address bar.</li>\n\t\t\t\t\t<li>Enable the Microphone.</li>\n\t\t\t\t\t<li>Ensure that "Microphone" is set to "Allow".</li>\n\t\t\t\t\t<li>Refresh the page.</li>\n\t\t\t\t</ol>';break;case"Edge":e='<p>To enable the microphone in Edge:</p>\n\t\t\t\t<ol>\n\t\t\t\t\t<li>Click the padlock icon in the address bar.</li>\n\t\t\t\t\t<li>Select "Permissions for this site".</li>\n\t\t\t\t\t<li>Ensure that "Microphone" is set to "Allow".</li>\n\t\t\t\t\t<li>Refresh the page.</li>\n\t\t\t\t</ol>';break;case"Safari":e='<p>To enable the microphone in Safari:</p>\n\t\t\t\t<ol>\n\t\t\t\t\t<li>Open "Safari" > "Preferences".</li>\n\t\t\t\t\t<li>Go to the "Websites" tab.</li>\n\t\t\t\t\t<li>Scroll down to "Microphone" on the left sidebar.</li>\n\t\t\t\t\t<li>Set the microphone permission to "Allow" for this website.</li>\n\t\t\t\t\t<li>Refresh the page.</li>\n\t\t\t\t</ol>';break;case"Firefox":e="<p>Firefox does not support browser speech recognition. Use Chrome.</p>";break;default:e="<p>Your browser may not fully support the Speech Recognition API or microphone access.</p>\n\t\t\t\t<p>Please ensure your browser is up to date, or try using Chrome, Edge, or Safari.</p>"}this.MTai.updateStatus(e)}async testMicrophoneVolume(){try{const t=await navigator.mediaDevices.getUserMedia({audio:!0});this.currentAudioStream=t;const e=new AudioContext,i=e.createMediaStreamSource(t),s=e.createAnalyser();i.connect(s);const n=new Uint8Array(s.fftSize);let r;const o=()=>{if(!this.recognizing)return t.getTracks().forEach((t=>t.stop())),e.close(),void cancelAnimationFrame(r);s.getByteFrequencyData(n);let i=n.reduce(((t,e)=>t+e))/n.length>10;this.MTai.updateStatus(i?"Receiving speech...":"Awaiting speech..."),i&&document.getElementById("ai-assistant-panel").classList.add("mic-receiving"),r=requestAnimationFrame(o)};o()}catch(t){console.error("Error accessing microphone:",t),this.MTai.updateStatus("Error accessing microphone: "+t.message,"error")}}}