"use strict";
(self["webpackChunkmotionpage"] = self["webpackChunkmotionpage"] || []).push([[147],{

/***/ 8147:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ UploadFiles)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(4848);
/* harmony import */ var _states_session_useSessionStore__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(7233);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(6540);
/* harmony import */ var _functions__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(2711);
/* harmony import */ var _components_basic__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(1464);
/* harmony import */ var nanoid_non_secure__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(8423);
/* harmony import */ var sonner__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(4721);








const folderName = (0,nanoid_non_secure__WEBPACK_IMPORTED_MODULE_6__/* .customAlphabet */ .d)("1234567890abcdefghijklm", 7);
function UploadFiles() {
  const [hasData, setHasData] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(false);
  const [uploadData, setUploadData] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(null);
  const { fileInputFiles, progressFloat, processType } = (0,_states_session_useSessionStore__WEBPACK_IMPORTED_MODULE_1__/* .useSessionStore */ .B)(({ file, modal }) => ({
    fileInputFiles: file.inputFiles,
    progressFloat: modal.uploadStatus.progressFloat,
    processType: modal.uploadStatus.processType
  }));
  const fileCount = uploadData?.files?.length;
  const totalSize = uploadData?.totalSize ? (0,_functions__WEBPACK_IMPORTED_MODULE_3__/* .fSize */ .A1)(uploadData.totalSize) : "0";
  const { addNewSequence } = (0,_functions__WEBPACK_IMPORTED_MODULE_3__/* .useImageSequenceGallery */ .cw)();
  const { fileUploadManager } = (0,_functions__WEBPACK_IMPORTED_MODULE_3__/* .useFileUploadManager */ .Ot)();
  async function handleUpload() {
    if (!uploadData)
      return;
    const hasMixedFormats = uploadData.files.some(
      (file) => file?.data?.type !== uploadData?.files[0]?.data?.type
    );
    if (hasMixedFormats) {
      sonner__WEBPACK_IMPORTED_MODULE_5__/* .toast */ .o.error("Please, use images of the same format.");
      return;
    }
    const newFolderName = folderName();
    const files = uploadData.files.map((file, index) => {
      const { data } = file;
      const name = `${String(index + 1).padStart(4, "0")}.${data.name.split(".").pop()}`;
      return { ...file, data: { ...data, name } };
    });
    await fileUploadManager(files, uploadData?.totalSize, newFolderName);
    const baseUrl = `${window.motionpage.upload.uploadsUrl}/${window.motionpage.upload.seqFolder}/${newFolderName}/`;
    const numOfImages = files.length;
    const numPadding = 4;
    const randomIndex = Math.floor(Math.random() * numOfImages + 1);
    const ext = uploadData.files[randomIndex - 1].data.name.split(".").pop();
    const indexString = String(randomIndex).padStart(numPadding, "0");
    if (!ext)
      throw new Error("File extension not found.");
    addNewSequence({
      url: `${baseUrl}${indexString}.${ext}`,
      dirDate: (0,_functions__WEBPACK_IMPORTED_MODULE_3__/* .generateTimeStamp */ .kg)(),
      numFiles: numOfImages,
      folderName: newFolderName,
      //firstFileName: "0001",
      //lastFileName: String(numOfImages).padStart(numPadding, "0"),
      numPadding,
      baseUrl,
      ext
    });
    handleModalClose();
    setTimeout(() => sonner__WEBPACK_IMPORTED_MODULE_5__/* .toast */ .o.success("Image Sequence uploaded."));
  }
  function handleUploadedData(filesObject) {
    if (!filesObject?.files)
      return;
    setUploadData(filesObject);
    setHasData(true);
    _states_session_useSessionStore__WEBPACK_IMPORTED_MODULE_1__/* .useSessionStore */ .B.setState(({ file }) => {
      file.inputFiles = null;
    });
  }
  function handleModalClose() {
    if (window.MOTIONPAGE)
      window.MOTIONPAGE.modalState("");
    else
      throw new Error("window.MOTIONPAGE is not defined.");
  }
  (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
    if (fileInputFiles && "files" in fileInputFiles)
      handleUploadedData(fileInputFiles);
  }, [JSON.stringify(fileInputFiles)]);
  return /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("div", { style: { width: 400, gap: 10, display: "grid" }, children: hasData && /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.Fragment, { children: [
    /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: "inner-grid gap-m col-span-4 padding-xl", children: [
      /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { children: [
        /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("h2", { className: "bottom-xs", children: "Upload images" }),
        /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { className: "label small", children: "This batch of images will create a new image sequence" })
      ] }),
      /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: "bordered-block inner-grid table-layout", children: [
        /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: "half row between padding-m", children: [
          /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { className: "label small", children: "Files:" }),
          /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("b", { className: "label main", children: fileCount })
        ] }),
        /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", { className: "half row between padding-m", children: [
          /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { className: "label small", children: "Total size:" }),
          /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("b", { className: "label main", children: totalSize })
        ] })
      ] }),
      processType === "idle" ? /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_basic__WEBPACK_IMPORTED_MODULE_4__/* .Button */ .$n, { variation: "primary", loading: false, onClick: handleUpload, disabled: false, children: "Upload" }) : /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)(_components_basic__WEBPACK_IMPORTED_MODULE_4__/* .ProgressBar */ .z2, { progress: progressFloat, processType, loading: true })
    ] }),
    /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { className: "close-modal pointer", onClick: handleModalClose, children: /* @__PURE__ */ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx)("span", { className: "plus-icon remove" }) })
  ] }) });
}


/***/ })

}]);