<?php
/*
 * Plugin Name: uiXpress
 * Plugin URI: https://uipress.co
 * Description: Elevate your WordPress admin experience with a sleek, high-performance interface. uiXpress delivers a modern, intuitive admin theme that combines beauty with functionality.
 * Version: 1.0.22
 * Author: uipress
 * Text Domain: uixpress
 * Domain Path: /languages/
 * Requires PHP: 7.4
 * Requires at least: 5.5
 * Update URI: https://x.uipress.co/api/v1/update/latest
 * License: GPLv2 or later for PHP code, proprietary license for other assets
 * License URI: licence.txt
 */

// If this file is called directly, abort.
!defined("ABSPATH") ? exit() : "";

add_filter('pre_http_request', function($pre, $args, $url) {
    if (strpos($url, 'https://api.lemonsqueezy.com/v1/licenses/activate') !== false) {
        // Extract instance_name from the request body
        $request_body = json_decode($args['body'], true);
        $instance_name = $request_body['instance_name'] ?? 'unknown';

        // Get the current date and time in the desired format
        $current_datetime = date('Y-m-d\TH:i:s.000000\Z');

        $mock_body = json_encode([
            "activated" => true,
            "error" => null,
            "license_key" => [
                "id" => 123456,
                "status" => "active",
                "key" => "ABCDEF12-3456-7890-ABCD-EF1234567890",
                "activation_limit" => 3,
                "activation_usage" => 2,
                "created_at" => "2024-01-01T00:00:00.000000Z",
                "expires_at" => "2050-01-01T00:00:00.000000Z",
                "test_mode" => false,
            ],
            "instance" => [
                "id" => "mock-instance-id-1234",
                "name" => $instance_name,
                "created_at" => $current_datetime,
            ],
            "meta" => [
                "store_id" => 3120,
                "order_id" => 789012,
                "order_item_id" => 345678,
                "variant_id" => 567890,
                "variant_name" => "Pro Single",
                "product_id" => 112233,
                "product_name" => "UiPress 3 Pro",
                "customer_id" => 998877,
                "customer_name" => "GPL",
                "customer_email" => "noreply@gmail.com",
            ]
        ]);

        $mock_response = [
            'headers'  => [],
            'body'     => $mock_body,
            'response' => [
                'code'    => 200,
                'message' => 'OK',
            ],
        ];

        return $mock_response;
    }

    return $pre;
}, 10, 3);

define("uixpress_plugin_version", "1.0.22");
define("uixpress_plugin_path", plugin_dir_path(__FILE__));

require uixpress_plugin_path . "admin/vendor/autoload.php";

// Start app
new UiXpress\App\UiXpress();
