<?php
/*
 * Table Rate Shipping Method Extender Class
 */

if ( ! defined( 'ABSPATH' ) )
	exit;

// Check if WooCommerce is active
if ( class_exists( 'WooCommerce' ) && class_exists('WC_Measurement_Price_Calculator_Loader') ) {

	if ( class_exists( 'BETRS_Measurement_Price_Calc' ) ) return;

	class BETRS_Measurement_Price_Calc {

		/**
		 * Cloning is forbidden. Will deactivate prior 'instances' users are running
		 *
		 * @since 4.0
		 */
		public function __clone() {
			_doing_it_wrong( __FUNCTION__, esc_html__( 'Cloning this class could cause catastrophic disasters!', 'be-table-ship' ), '4.0' );
		}

		/**
		 * Unserializing instances of this class is forbidden.
		 *
		 * @since 4.0
		 */
		public function __wakeup() {
			_doing_it_wrong( __FUNCTION__, esc_html__( 'Unserializing is forbidden!', 'be-table-ship' ), '4.0' );
		}

		/**
		 * __construct function.
		 *
		 * @access public
		 * @return void
		 */
		function __construct() {

			// modify the necessary cart calculations through filters
			add_filter( 'betrs_calculated_item-height', array( $this, 'override_height' ), 10, 2 );
			add_filter( 'betrs_calculated_item-length', array( $this, 'override_length' ), 10, 2 );
			add_filter( 'betrs_calculated_item-width', array( $this, 'override_width' ), 10, 2 );
			add_filter( 'betrs_calculated_item-weight', array( $this, 'override_weight' ), 10, 2 );

		}


		/**
		 * override cart item height when user entered.
		 *
		 * @access public
		 * @param array $package (default: array())
		 * @return void
		 */
		function override_height( $height, $item_ar ) {

			// check if product has user measurements enabled
			if( isset( $item_ar['pricing_item_meta_data'] ) && ! empty( $item_ar['pricing_item_meta_data']['height'] ) ) {
				$height = $item_ar['pricing_item_meta_data']['height'];
			}

			return $height;
		}


		/**
		 * override cart item length when user entered.
		 *
		 * @access public
		 * @param array $package (default: array())
		 * @return void
		 */
		function override_length( $length, $item_ar ) {
			
			// check if product has user measurements enabled
			if( isset( $item_ar['pricing_item_meta_data'] ) && ! empty( $item_ar['pricing_item_meta_data']['length'] ) ) {
				$length = $item_ar['pricing_item_meta_data']['length'];
			}

			return $length;
		}


		/**
		 * override cart item width when user entered.
		 *
		 * @access public
		 * @param array $package (default: array())
		 * @return void
		 */
		function override_width( $width, $item_ar ) {
			
			// check if product has user measurements enabled
			if( isset( $item_ar['pricing_item_meta_data'] ) && ! empty( $item_ar['pricing_item_meta_data']['width'] ) ) {
				$width = $item_ar['pricing_item_meta_data']['width'];
			}

			return $width;
		}


		/**
		 * override cart item weight when custom quantity entered.
		 *
		 * @access public
		 * @param array $package (default: array())
		 * @return void
		 */
		function override_weight( $weight, $item_ar ) {
			
			// check if product has user measurements enabled
			if( isset( $item_ar['available_quantity'] ) && ! empty( $item_ar['available_quantity'] ) ) {
				$weight = $weight * $item_ar['available_quantity'];
			}

			return $weight;
		}

	}

	new BETRS_Measurement_Price_Calc();

}

?>