<?php
/**
 * Dokan Frontend View: User Shipping Management
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

?>	
<p class="woocommerce-info"><?php esc_html_e( 'Table Rate options can only be modified by administrators. Please contact the marketplace order for help making any changes to your shipping options.', 'be-table-ship' ); ?></p>
	
		<div id="BETRS-table-rates-parent">
<?php
			foreach( $settings as $rowID => $option ) {
?>
			<div class="single-row" data-row_id='<?php echo absint( $rowID ); ?>'>
				<h4 class="shipping-headline">Shipping Option #<?php echo absint( $rowID ); ?></h4>
				<div class="single-row-left">
					<div class="titlewrap">
						<h3 class="shipping-title">
							<span><?php esc_html_e( 'Shipping Option Title', 'be-table-ship' ); ?></span>
							<?php echo stripslashes( sanitize_text_field( $option['title'] ) ); ?>
						</h3>
						<h3 class="shipping-desc">
							<span><?php esc_html_e( 'Description', 'be-table-ship' ); ?></span>
							<?php echo stripslashes( sanitize_text_field( $option['description'] ) ); ?>
						</h3>
					</div>

					<table class="table_rates">
					    <thead>
					    <tr>
<?php
				foreach( $columns as $column ) {
					echo "<th>" . sanitize_text_field( $column ) . "</th>";
				}
?>
					    </tr>
					    </thead>
					 
					    <tbody>

<?php 
				foreach( $option['rows'] as $row ) { 
?>					
						<tr>					
<?php 
					foreach( $columns as $column_id => $column ) { 
?>

							<td>
<?php 
					switch( $column_id ) {
						case 'conditions':
							if( is_array( $row['conditions'] ) && ! empty( $row['conditions'] ) ) {
								foreach( $row['conditions'] as $condition ) {
									echo "<p>";
									$cond_type = sanitize_key( $condition['cond_type'] );
									if( $cond_type != '' && array_key_exists( $cond_type, $betrs_shipping->table_rates->conditional_statements ) ) {
										echo $betrs_shipping->table_rates->conditional_statements[ $cond_type ] . " ";
									}
									$cond_secondary = sanitize_key( $condition['cond_secondary'] );
									if( $cond_secondary != '' && array_key_exists( $cond_secondary, $betrs_shipping->table_rates->secondary_statements ) ) {
										echo $betrs_shipping->table_rates->secondary_statements[ $cond_secondary ]['title'] . " ";
									}
									if( is_array( $condition['cond_tertiary'] ) ) {
										$cond_tertiary = array_map( 'wc_clean', $condition['cond_tertiary'] );
										if( $cond_type == 'product' ) {
											$temp_products = array();
											foreach( $cond_tertiary as $value ) {
												$prod = wc_get_product( $value );
                        						if ( is_object( $prod ) ) {
                        							$temp_products[] = $prod->get_formatted_name();
                        						}
											}
											echo " " . implode( ', ', $temp_products );
										} else {
											echo " " . implode( ', ', $cond_tertiary );
										}
									} else {
										$cond_tertiary = sanitize_text_field( $condition['cond_tertiary'] );
										if( $cond_type == 'subtotal' ) $cond_tertiary = wc_price( $cond_tertiary );
										switch( $cond_type ) {
											case 's_class':
											break;
											case 'category':
											break;
											case 'coupon':
											
											break;
										}
										echo " " . $cond_tertiary;
									}
									echo "</p>";
								}
							}
						break;
						case 'costs':
							if( is_array( $row['costs'] ) && ! empty( $row['costs'] ) ) {
								foreach( $row['costs'] as $cost ) {
									echo "<p>";
									echo wc_price( $cost['cost_value'] ) . " ";
									$cost_op = sanitize_text_field( $cost['cost_type'] );
									if( $cost_op != '' && array_key_exists( $cost_op, $betrs_shipping->table_rates->cost_ops ) ) {
										echo $betrs_shipping->table_rates->cost_ops[ $cost_op ] . " ";

										if( $cost_op === 'x' ) {
											$cost_op_extra = sanitize_key( $cost['cost_op_extra'] );
											if( $cost_op_extra != '' && array_key_exists( $cost_op_extra, $betrs_shipping->table_rates->cost_units_multi ) ) {
												echo $betrs_shipping->table_rates->cost_units_multi[ $cost_op_extra ];
											}
										} elseif( $cost_op === 'every' ) {
											echo sanitize_text_field( $cost['cost_op_extra_val'] ) . " ";
											$cost_op_extra_secondary = sanitize_key( $cost["cost_op_extra_secondary"] );
											if( $cost_op_extra_secondary != '' && array_key_exists( $cost_op_extra_secondary, $betrs_shipping->table_rates->dimension_types ) ) {
												echo $betrs_shipping->table_rates->dimension_types[ $cost_op_extra_secondary ];
											}
										}
									}
									echo "</p>";
								}
							}
						break;
						case 'description':
							echo stripslashes( wp_kses( $row['description'], $betrs_shipping->allowedtags ) );
						break;
					} 
?>
							</td>
<?php 
				} 
?>
					</tr>
<?php 
			} 
?>

					    </tbody>
					    <tfoot>
					    <tr>
<?php
				foreach( $columns as $column ) {
					echo "<th>" . sanitize_text_field( $column ) . "</th>";
				}
?>
					    </tr>
					    </tfoot>
					</table>
				</div>
				<div class="single-row-right">
					<div class="additional-settings">
						<h3><?php esc_html_e( 'Additional Settings', 'be-table-ship' ); ?></h3>
						<p><strong><?php esc_html_e( 'Default Selection', 'be-table-ship' ); ?>:</strong>
							<?php ( sanitize_title( $option['default'] ) === 'on' ) ? esc_html_e( 'Yes', 'be-table-ship' ) : esc_html_e( 'No', 'be-table-ship' ); ?></p>
						<p><strong><?php esc_html_e( 'Hide Other Options', 'be-table-ship' ); ?>:</strong>
							<?php ( sanitize_title( $option['hide_ops'] ) === 'on' ) ? esc_html_e( 'Yes', 'be-table-ship' ) : esc_html_e( 'No', 'be-table-ship' ); ?></p>
						<p><strong><?php esc_html_e( 'Disable Option', 'be-table-ship' ); ?>:</strong>
							<?php ( sanitize_title( $option['disable_op'] ) === 'on' ) ? esc_html_e( 'Yes', 'be-table-ship' ) : esc_html_e( 'No', 'be-table-ship' ); ?></p>
						<p><strong><?php esc_html_e( 'Combine Descriptions', 'be-table-ship' ); ?></strong>
							<?php ( sanitize_title( $option['combine_desc'] ) === 'on' ) ? esc_html_e( 'Yes', 'be-table-ship' ) : esc_html_e( 'No', 'be-table-ship' ); ?></p>
						<?php do_action( 'betrs_additional_rate_settings_frontend', $rowID, $option ); ?>
					</div>
				</div>
				<div style="clear:both;"></div>
			</div>
		</div>
<?php
	}