<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Compile system roles into an array
$roles = ( is_admin() && function_exists( 'get_editable_roles' ) ) ? get_editable_roles() : array();
$user_roles = array();
foreach( $roles as $key => $role )
	$user_roles[ $key ] = $role[ 'name' ];
$user_roles['guest'] = "Users Not Logged In";

// check if form fields has been populated yet
$form_fields = $this->get_instance_form_fields();

// Miscellaneous variables for descriptions
$volumetric_operand = ( isset( $form_fields['volumetric_operand'] ) ) ? $this->get_instance_option( 'volumetric_operand' ) : '';
$operand = ( ! empty( $volumetric_operand ) && $volumetric_operand == 'multiply' ) ? 'x' : '/';

// Retrieve select modification users
$users = array();
$saved_modifiers = ( isset( $form_fields['user_modification_users'] ) ) ? $this->get_instance_option( 'user_modification_users' ) : '';
if( ! empty( $saved_modifiers ) && is_array( $saved_modifiers ) ) {
	$users_query = new WP_User_Query( array(
			'include' 	=> $saved_modifiers,
			'fields'	=> 'ID',
		) );
	$users_results = wp_parse_id_list( (array) $users_query->get_results() );
	if( ! empty( $users_results ) ) {
		foreach ( $users_results as $id ) {
			$customer = new WC_Customer( $id );
			// translators: 1: user display name 2: user ID 3: user email
			$users[ $id ] = sprintf(
				esc_html__( '%1$s (#%2$s &ndash; %3$s)', 'woocommerce' ),
				$customer->get_first_name() . ' ' . $customer->get_last_name(),
				$customer->get_id(),
				$customer->get_email()
			);
		}
	}
}

/**
 * Settings for table rate shipping.
 */
$settings['general'] = array(
	'title'		=> esc_html__( 'General Settings', 'be-table-ship' ),
	'settings'	=> array(
		'title' => array(
			'title' 		=> esc_html__( 'Method Title', 'woocommerce' ),
			'type' 			=> 'text',
			'description' 	=> esc_html__( 'For your reference', 'be-table-ship' ),
			'default' 		=> esc_html__( 'Table Rate Shipping', 'be-table-ship' ),
			'css'			=> 'min-width:350px;',
			),
		'tax_status' => array(
			'title' 		=> esc_html__( 'Tax Status', 'woocommerce' ),
			'type' 			=> 'select',
			'class'         => 'wc-enhanced-select',
			'default' 		=> 'taxable',
			'options'		=> array(
				'taxable' 	=> esc_html__( 'Taxable', 'woocommerce' ),
				'none' 		=> esc_html_x( 'None', 'Tax status', 'woocommerce' )
			)
		),
		'condition' => array(
			'title' 		=> esc_html__( 'Base Table Rules', 'be-table-ship' ),
			'type' 			=> 'select',
			'class'         => 'wc-enhanced-select',
			'default' 		=> 'per-order',
			'options' 		=> apply_filters( 'betrs_conditional_types', array(
				'per-order' 	=> esc_html__( 'Per Order', 'be-table-ship' ),
				'per-item' 		=> esc_html__( 'Per Item', 'be-table-ship' ),
				'per-line-item' => esc_html__( 'Per Line Item', 'be-table-ship' ),
				'per-class' 	=> esc_html__( 'Per Class', 'be-table-ship' ),
				) ),
			),
		),
	'priority'	=> 0,
);
$settings['user_permissions'] = array(
	'title'		=> esc_html__( 'User Permissions', 'be-table-ship' ),
	'settings'	=> array(
		'user_limitation' => array(
			'title' 			=> esc_html__( 'Shipping options appear for', 'be-table-ship' ),
			'type' 				=> 'select',
			'class'         	=> 'wc-enhanced-select',
			'default' 			=> 'everyone',
			'options' 			=> apply_filters( 'betrs_user_restriction_types', array(
				'everyone' 			=> esc_html__( 'Everyone', 'be-table-ship' ),
				'specific-roles'	=> esc_html__( 'Specific Roles', 'be-table-ship' ),
				) ),
			),
		'user_limitation_roles' => array(
			'title' 			=> esc_html__( 'Ship to roles', 'be-table-ship' ),
			'type' 				=> 'multiselect',
			'class'         	=> 'wc-enhanced-select',
			'default' 			=> '',
			'options' 			=> $user_roles,
			),
		'user_modification' => array(
			'title' 			=> esc_html__( 'Settings can be modified by', 'be-table-ship' ),
			'type' 				=> 'select',
			'class'         	=> 'wc-enhanced-select',
			'default' 			=> 'admins',
			'options' 			=> apply_filters( 'betrs_user_modification_types', array(
				'admins' 			=> esc_html__( 'Admins Only', 'be-table-ship' ),
				'specific-roles'	=> esc_html__( 'Specific Roles', 'be-table-ship' ),
				'specific-users'	=> esc_html__( 'Specific Users', 'be-table-ship' ),
				) ),
			),
		'user_modification_roles' => array(
			'title' 			=> esc_html__( 'User Roles', 'be-table-ship' ),
			'type' 				=> 'multiselect',
			'class'         	=> 'wc-enhanced-select',
			'default' 			=> '',
			'options' 			=> $user_roles,
			),
		'user_modification_users' => array(
			'title' 			=> esc_html__( 'Users', 'be-table-ship' ),
			'type' 				=> 'multiselect',
			'class'         	=> 'wc-customer-search',
			'default' 			=> '',
			'custom_attributes' => array( 'data-action' => 'woocommerce_json_search_customers' ),
			'options' 			=> $users,
			),
		),
	'priority'	=> 10,
);

// disable shipping by user if running an older version of WooCommerce
if( version_compare( WC_VERSION, '3.0', "<" ) ) {
	unset( $settings['user_permissions']['settings']['user_modification_users'] );
	unset( $settings['user_permissions']['settings']['user_modification']['options']['specific-users'] );
}

$settings['volumetric'] = array(
	'title'		=> esc_html__( 'Volumetric Settings', 'be-table-ship' ),
	'settings'	=> array(
		'volumetric_number' => array(
			'id'			=> 'volumetric_number',
			'title' 		=> esc_html__( 'Volumetric Number', 'be-table-ship' ),
			'type' 			=> 'text',
			'description'		=> esc_html__( 'Equation', 'be-table-ship' ) . ': ( L x W x H ) <span>' . $operand  . '</span> ' . esc_html__( 'Volumetric Number', 'be-table-ship' ),
			'default' 		=> '',
			'css'			=> 'min-width:350px;',
			'class'			=> 'volumetric_number',
		),
		'volumetric_operand' => array(
			'id'			=> 'volumetric_operand',
			'title' 		=> esc_html__( 'Operand', 'be-table-ship' ),
			'type' 			=> 'select',
			'default' 		=> 'divide',
			'class'			=> 'wc-enhanced-select operand_selector',
			'css'			=> 'min-width:350px;',
			'options' 		=> array(
				'divide'	=> esc_html__( 'Divide', 'be-table-ship' ),
				'multiply' 	=> esc_html__( 'Multiply', 'be-table-ship' ),
				)
		),
		'volumetric_exclude' => array(
			'id'			=> 'volumetric_exclude',
			'title' 		=> esc_html__( 'Exclude Weight', 'be-table-ship' ),
			'type' 			=> 'checkbox',
			'description'	=> esc_html__( 'Do not compare product weight to calculated volumetric weight. Weight condition should always equal the volumetric weight.', 'be-table-ship' ),
			'default' 		=> 'no',
		),
		'volumetric_dim_rec' => array(
			'id'			=> 'volumetric_dim_rec',
			'title' 		=> esc_html__( 'Require Dimensions', 'be-table-ship' ),
			'type' 			=> 'checkbox',
			'description'	=> esc_html__( 'Require one or more dimensional fields, otherwise physical weight is used.', 'be-table-ship' ),
			'default' 		=> 'no',
		),
	),
	'priority'	=> 20,
);
$settings['other'] = array(
	'title'		=> esc_html__( 'Additional Options', 'be-table-ship' ),
	'settings'	=> array(
		'includetax' => array(
			'id'			=> 'includetax',
			'title' 		=> esc_html__( 'Include Tax', 'be-table-ship' ),
			'type' 			=> 'checkbox',
			'description'	=> esc_html__( 'Calculate shipping based on prices AFTER tax', 'be-table-ship' ),
			'default' 		=> 'no',
		),
		'include_coupons' => array(
			'id'			=> 'include_coupons',
			'title' 		=> esc_html__( 'Include Coupons', 'be-table-ship' ),
			'type' 			=> 'checkbox',
			'description'	=> esc_html__( 'Subtotal is calculated based on cart value after coupons', 'be-table-ship' ),
			'default' 		=> 'no',
		),
		'single_class' => array(
			'id'			=> 'single_class',
			'title' 		=> esc_html__( 'Single Class Only', 'be-table-ship' ),
			'type' 			=> 'select',
			'default' 		=> 'disabled',
			'options' 		=> array(
				'disabled'	=> esc_html__( 'Disabled', 'be-table-ship' ),
				'priority' 	=> esc_html__( 'Highest Priority', 'be-table-ship' ),
				'cost_high' => esc_html__( 'Highest Costing Class', 'be-table-ship' ),
				'cost_low'	=> esc_html__( 'Lowest Costing Class', 'be-table-ship' ),
				),
			'class'			=> 'per-class-only',
		),
		'round_weight' => array(
			'id'			=> 'round_weight',
			'title' 		=> esc_html__( 'Round Weight', 'be-table-ship' ),
			'type' 			=> 'checkbox',
			'description'	=> esc_html__( 'Rounds weight value up to the next whole number', 'be-table-ship' ),
			'default' 		=> 'no',
		),
		'hide_method' => array(
			'id'			=> 'hide_method',
			'title' 		=> esc_html__( 'Hide This Method', 'be-table-ship' ),
			'type' 			=> 'checkbox',
			'description'	=> esc_html__( 'Hide This Shipping Method When the Free Shipping Method is Available', 'be-table-ship' ),
			'default' 		=> 'no',
		),
	),
	'priority'	=> 50,
);

return $settings;
